package zio.aws.location.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import zio.aws.location.model.primitives.{Timestamp, ResourceName, Arn}
import scala.jdk.CollectionConverters._
final case class UpdatePlaceIndexResponse(
    indexArn: Arn,
    indexName: ResourceName,
    updateTime: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.UpdatePlaceIndexResponse = {
    import UpdatePlaceIndexResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.UpdatePlaceIndexResponse
      .builder()
      .indexArn(Arn.unwrap(indexArn): java.lang.String)
      .indexName(ResourceName.unwrap(indexName): java.lang.String)
      .updateTime(Timestamp.unwrap(updateTime): Instant)
      .build()
  }
  def asReadOnly: zio.aws.location.model.UpdatePlaceIndexResponse.ReadOnly =
    zio.aws.location.model.UpdatePlaceIndexResponse.wrap(buildAwsValue())
}
object UpdatePlaceIndexResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.UpdatePlaceIndexResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.UpdatePlaceIndexResponse =
      zio.aws.location.model
        .UpdatePlaceIndexResponse(indexArn, indexName, updateTime)
    def indexArn: Arn
    def indexName: ResourceName
    def updateTime: Timestamp
    def getIndexArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(indexArn)
    def getIndexName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(indexName)
    def getUpdateTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(updateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.UpdatePlaceIndexResponse
  ) extends zio.aws.location.model.UpdatePlaceIndexResponse.ReadOnly {
    override val indexArn: Arn =
      zio.aws.location.model.primitives.Arn(impl.indexArn())
    override val indexName: ResourceName =
      zio.aws.location.model.primitives.ResourceName(impl.indexName())
    override val updateTime: Timestamp =
      zio.aws.location.model.primitives.Timestamp(impl.updateTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.UpdatePlaceIndexResponse
  ): zio.aws.location.model.UpdatePlaceIndexResponse.ReadOnly = new Wrapper(
    impl
  )
}
