package zio.aws.location.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.location.model.primitives.{ResourceDescription, ResourceName}
import scala.jdk.CollectionConverters._
final case class UpdateRouteCalculatorRequest(
    calculatorName: ResourceName,
    description: Option[ResourceDescription] = None,
    pricingPlan: Option[zio.aws.location.model.PricingPlan] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.UpdateRouteCalculatorRequest = {
    import UpdateRouteCalculatorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.UpdateRouteCalculatorRequest
      .builder()
      .calculatorName(ResourceName.unwrap(calculatorName): java.lang.String)
      .optionallyWith(
        description.map(value =>
          ResourceDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(pricingPlan.map(value => value.unwrap))(_.pricingPlan)
      .build()
  }
  def asReadOnly: zio.aws.location.model.UpdateRouteCalculatorRequest.ReadOnly =
    zio.aws.location.model.UpdateRouteCalculatorRequest.wrap(buildAwsValue())
}
object UpdateRouteCalculatorRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.UpdateRouteCalculatorRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.UpdateRouteCalculatorRequest =
      zio.aws.location.model.UpdateRouteCalculatorRequest(
        calculatorName,
        description.map(value => value),
        pricingPlan.map(value => value)
      )
    def calculatorName: ResourceName
    def description: Option[ResourceDescription]
    def pricingPlan: Option[zio.aws.location.model.PricingPlan]
    def getCalculatorName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(calculatorName)
    def getDescription: ZIO[Any, AwsError, ResourceDescription] =
      AwsError.unwrapOptionField("description", description)
    def getPricingPlan: ZIO[Any, AwsError, zio.aws.location.model.PricingPlan] =
      AwsError.unwrapOptionField("pricingPlan", pricingPlan)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.UpdateRouteCalculatorRequest
  ) extends zio.aws.location.model.UpdateRouteCalculatorRequest.ReadOnly {
    override val calculatorName: ResourceName =
      zio.aws.location.model.primitives.ResourceName(impl.calculatorName())
    override val description: Option[ResourceDescription] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.location.model.primitives.ResourceDescription(value)
      )
    override val pricingPlan: Option[zio.aws.location.model.PricingPlan] = scala
      .Option(impl.pricingPlan())
      .map(value => zio.aws.location.model.PricingPlan.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.UpdateRouteCalculatorRequest
  ): zio.aws.location.model.UpdateRouteCalculatorRequest.ReadOnly = new Wrapper(
    impl
  )
}
