package zio.aws.location.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.location.model.primitives.{ResourceName, ResourceDescription}
import scala.jdk.CollectionConverters._
final case class UpdateTrackerRequest(
    description: Option[ResourceDescription] = None,
    positionFiltering: Option[zio.aws.location.model.PositionFiltering] = None,
    pricingPlan: Option[zio.aws.location.model.PricingPlan] = None,
    pricingPlanDataSource: Option[String] = None,
    trackerName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.UpdateTrackerRequest = {
    import UpdateTrackerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.UpdateTrackerRequest
      .builder()
      .optionallyWith(
        description.map(value =>
          ResourceDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(positionFiltering.map(value => value.unwrap))(
        _.positionFiltering
      )
      .optionallyWith(pricingPlan.map(value => value.unwrap))(_.pricingPlan)
      .optionallyWith(
        pricingPlanDataSource.map(value => value: java.lang.String)
      )(_.pricingPlanDataSource)
      .trackerName(ResourceName.unwrap(trackerName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.location.model.UpdateTrackerRequest.ReadOnly =
    zio.aws.location.model.UpdateTrackerRequest.wrap(buildAwsValue())
}
object UpdateTrackerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.UpdateTrackerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.UpdateTrackerRequest =
      zio.aws.location.model.UpdateTrackerRequest(
        description.map(value => value),
        positionFiltering.map(value => value),
        pricingPlan.map(value => value),
        pricingPlanDataSource.map(value => value),
        trackerName
      )
    def description: Option[ResourceDescription]
    def positionFiltering: Option[zio.aws.location.model.PositionFiltering]
    def pricingPlan: Option[zio.aws.location.model.PricingPlan]
    def pricingPlanDataSource: Option[String]
    def trackerName: ResourceName
    def getDescription: ZIO[Any, AwsError, ResourceDescription] =
      AwsError.unwrapOptionField("description", description)
    def getPositionFiltering
        : ZIO[Any, AwsError, zio.aws.location.model.PositionFiltering] =
      AwsError.unwrapOptionField("positionFiltering", positionFiltering)
    def getPricingPlan: ZIO[Any, AwsError, zio.aws.location.model.PricingPlan] =
      AwsError.unwrapOptionField("pricingPlan", pricingPlan)
    def getPricingPlanDataSource: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("pricingPlanDataSource", pricingPlanDataSource)
    def getTrackerName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(trackerName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.UpdateTrackerRequest
  ) extends zio.aws.location.model.UpdateTrackerRequest.ReadOnly {
    override val description: Option[ResourceDescription] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.location.model.primitives.ResourceDescription(value)
      )
    override val positionFiltering
        : Option[zio.aws.location.model.PositionFiltering] = scala
      .Option(impl.positionFiltering())
      .map(value => zio.aws.location.model.PositionFiltering.wrap(value))
    override val pricingPlan: Option[zio.aws.location.model.PricingPlan] = scala
      .Option(impl.pricingPlan())
      .map(value => zio.aws.location.model.PricingPlan.wrap(value))
    override val pricingPlanDataSource: Option[String] =
      scala.Option(impl.pricingPlanDataSource()).map(value => value: String)
    override val trackerName: ResourceName =
      zio.aws.location.model.primitives.ResourceName(impl.trackerName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.UpdateTrackerRequest
  ): zio.aws.location.model.UpdateTrackerRequest.ReadOnly = new Wrapper(impl)
}
