package zio.aws.location.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import zio.aws.location.model.primitives.{Timestamp, ResourceName, Arn}
import scala.jdk.CollectionConverters._
final case class UpdateTrackerResponse(
    trackerArn: Arn,
    trackerName: ResourceName,
    updateTime: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.UpdateTrackerResponse = {
    import UpdateTrackerResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.UpdateTrackerResponse
      .builder()
      .trackerArn(Arn.unwrap(trackerArn): java.lang.String)
      .trackerName(ResourceName.unwrap(trackerName): java.lang.String)
      .updateTime(Timestamp.unwrap(updateTime): Instant)
      .build()
  }
  def asReadOnly: zio.aws.location.model.UpdateTrackerResponse.ReadOnly =
    zio.aws.location.model.UpdateTrackerResponse.wrap(buildAwsValue())
}
object UpdateTrackerResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.UpdateTrackerResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.UpdateTrackerResponse =
      zio.aws.location.model
        .UpdateTrackerResponse(trackerArn, trackerName, updateTime)
    def trackerArn: Arn
    def trackerName: ResourceName
    def updateTime: Timestamp
    def getTrackerArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(trackerArn)
    def getTrackerName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(trackerName)
    def getUpdateTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(updateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.UpdateTrackerResponse
  ) extends zio.aws.location.model.UpdateTrackerResponse.ReadOnly {
    override val trackerArn: Arn =
      zio.aws.location.model.primitives.Arn(impl.trackerArn())
    override val trackerName: ResourceName =
      zio.aws.location.model.primitives.ResourceName(impl.trackerName())
    override val updateTime: Timestamp =
      zio.aws.location.model.primitives.Timestamp(impl.updateTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.UpdateTrackerResponse
  ): zio.aws.location.model.UpdateTrackerResponse.ReadOnly = new Wrapper(impl)
}
