package zio.aws.location
import zio.aws.location.model.primitives.SyntheticSearchPlaceIndexForTextSummaryString.Type
import zio.aws.location.model.primitives.{
  PropertyMapKeyString,
  PropertyMapValueString,
  TagValue,
  Arn,
  CountryCode,
  Id,
  TagKey
}
import java.time.Instant
import zio.Chunk
import zio.prelude.Subtype
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object Arn extends Subtype[String]
    type Arn = zio.aws.location.model.primitives.Arn.Type
    object BatchGetDevicePositionRequestTrackerNameString
        extends Subtype[String]
    type BatchGetDevicePositionRequestTrackerNameString =
      zio.aws.location.model.primitives.BatchGetDevicePositionRequestTrackerNameString.Type
    object Blob extends Subtype[Chunk[Byte]]
    type Blob = zio.aws.location.model.primitives.Blob.Type
    object CalculateRouteMatrixSummaryErrorCountInteger extends Subtype[Int]
    type CalculateRouteMatrixSummaryErrorCountInteger =
      zio.aws.location.model.primitives.CalculateRouteMatrixSummaryErrorCountInteger.Type
    object CalculateRouteMatrixSummaryRouteCountInteger extends Subtype[Int]
    type CalculateRouteMatrixSummaryRouteCountInteger =
      zio.aws.location.model.primitives.CalculateRouteMatrixSummaryRouteCountInteger.Type
    object CalculateRouteSummaryDistanceDouble extends Subtype[Double]
    type CalculateRouteSummaryDistanceDouble =
      zio.aws.location.model.primitives.CalculateRouteSummaryDistanceDouble.Type
    object CalculateRouteSummaryDurationSecondsDouble extends Subtype[Double]
    type CalculateRouteSummaryDurationSecondsDouble =
      zio.aws.location.model.primitives.CalculateRouteSummaryDurationSecondsDouble.Type
    object CountryCode extends Subtype[String]
    type CountryCode = zio.aws.location.model.primitives.CountryCode.Type
    object GetMapGlyphsRequestFontUnicodeRangeString extends Subtype[String]
    type GetMapGlyphsRequestFontUnicodeRangeString =
      zio.aws.location.model.primitives.GetMapGlyphsRequestFontUnicodeRangeString.Type
    object GetMapSpritesRequestFileNameString extends Subtype[String]
    type GetMapSpritesRequestFileNameString =
      zio.aws.location.model.primitives.GetMapSpritesRequestFileNameString.Type
    object GetMapTileRequestXString extends Subtype[String]
    type GetMapTileRequestXString =
      zio.aws.location.model.primitives.GetMapTileRequestXString.Type
    object GetMapTileRequestYString extends Subtype[String]
    type GetMapTileRequestYString =
      zio.aws.location.model.primitives.GetMapTileRequestYString.Type
    object GetMapTileRequestZString extends Subtype[String]
    type GetMapTileRequestZString =
      zio.aws.location.model.primitives.GetMapTileRequestZString.Type
    object Id extends Subtype[String]
    type Id = zio.aws.location.model.primitives.Id.Type
    type Integer = Int
    object KmsKeyId extends Subtype[String]
    type KmsKeyId = zio.aws.location.model.primitives.KmsKeyId.Type
    object LanguageTag extends Subtype[String]
    type LanguageTag = zio.aws.location.model.primitives.LanguageTag.Type
    object LegDistanceDouble extends Subtype[Double]
    type LegDistanceDouble =
      zio.aws.location.model.primitives.LegDistanceDouble.Type
    object LegDurationSecondsDouble extends Subtype[Double]
    type LegDurationSecondsDouble =
      zio.aws.location.model.primitives.LegDurationSecondsDouble.Type
    object ListDevicePositionsRequestMaxResultsInteger extends Subtype[Int]
    type ListDevicePositionsRequestMaxResultsInteger =
      zio.aws.location.model.primitives.ListDevicePositionsRequestMaxResultsInteger.Type
    object ListGeofenceCollectionsRequestMaxResultsInteger extends Subtype[Int]
    type ListGeofenceCollectionsRequestMaxResultsInteger =
      zio.aws.location.model.primitives.ListGeofenceCollectionsRequestMaxResultsInteger.Type
    object ListMapsRequestMaxResultsInteger extends Subtype[Int]
    type ListMapsRequestMaxResultsInteger =
      zio.aws.location.model.primitives.ListMapsRequestMaxResultsInteger.Type
    object ListPlaceIndexesRequestMaxResultsInteger extends Subtype[Int]
    type ListPlaceIndexesRequestMaxResultsInteger =
      zio.aws.location.model.primitives.ListPlaceIndexesRequestMaxResultsInteger.Type
    object ListRouteCalculatorsRequestMaxResultsInteger extends Subtype[Int]
    type ListRouteCalculatorsRequestMaxResultsInteger =
      zio.aws.location.model.primitives.ListRouteCalculatorsRequestMaxResultsInteger.Type
    object ListTrackerConsumersRequestMaxResultsInteger extends Subtype[Int]
    type ListTrackerConsumersRequestMaxResultsInteger =
      zio.aws.location.model.primitives.ListTrackerConsumersRequestMaxResultsInteger.Type
    object ListTrackersRequestMaxResultsInteger extends Subtype[Int]
    type ListTrackersRequestMaxResultsInteger =
      zio.aws.location.model.primitives.ListTrackersRequestMaxResultsInteger.Type
    object MapStyle extends Subtype[String]
    type MapStyle = zio.aws.location.model.primitives.MapStyle.Type
    object PlaceIndexSearchResultLimit extends Subtype[Int]
    type PlaceIndexSearchResultLimit =
      zio.aws.location.model.primitives.PlaceIndexSearchResultLimit.Type
    object PositionalAccuracyHorizontalDouble extends Subtype[Double]
    type PositionalAccuracyHorizontalDouble =
      zio.aws.location.model.primitives.PositionalAccuracyHorizontalDouble.Type
    object PropertyMapKeyString extends Subtype[String]
    type PropertyMapKeyString =
      zio.aws.location.model.primitives.PropertyMapKeyString.Type
    object PropertyMapValueString extends Subtype[String]
    type PropertyMapValueString =
      zio.aws.location.model.primitives.PropertyMapValueString.Type
    object ResourceDescription extends Subtype[String]
    type ResourceDescription =
      zio.aws.location.model.primitives.ResourceDescription.Type
    object ResourceName extends Subtype[String]
    type ResourceName = zio.aws.location.model.primitives.ResourceName.Type
    object RouteMatrixEntryDistanceDouble extends Subtype[Double]
    type RouteMatrixEntryDistanceDouble =
      zio.aws.location.model.primitives.RouteMatrixEntryDistanceDouble.Type
    object RouteMatrixEntryDurationSecondsDouble extends Subtype[Double]
    type RouteMatrixEntryDurationSecondsDouble =
      zio.aws.location.model.primitives.RouteMatrixEntryDurationSecondsDouble.Type
    object SearchForPositionResultDistanceDouble extends Subtype[Double]
    type SearchForPositionResultDistanceDouble =
      zio.aws.location.model.primitives.SearchForPositionResultDistanceDouble.Type
    object SearchForTextResultDistanceDouble extends Subtype[Double]
    type SearchForTextResultDistanceDouble =
      zio.aws.location.model.primitives.SearchForTextResultDistanceDouble.Type
    object SearchForTextResultRelevanceDouble extends Subtype[Double]
    type SearchForTextResultRelevanceDouble =
      zio.aws.location.model.primitives.SearchForTextResultRelevanceDouble.Type
    object SearchPlaceIndexForSuggestionsRequestMaxResultsInteger
        extends Subtype[Int]
    type SearchPlaceIndexForSuggestionsRequestMaxResultsInteger =
      zio.aws.location.model.primitives.SearchPlaceIndexForSuggestionsRequestMaxResultsInteger.Type
    object StepDistanceDouble extends Subtype[Double]
    type StepDistanceDouble =
      zio.aws.location.model.primitives.StepDistanceDouble.Type
    object StepDurationSecondsDouble extends Subtype[Double]
    type StepDurationSecondsDouble =
      zio.aws.location.model.primitives.StepDurationSecondsDouble.Type
    object StepGeometryOffsetInteger extends Subtype[Int]
    type StepGeometryOffsetInteger =
      zio.aws.location.model.primitives.StepGeometryOffsetInteger.Type
    object SyntheticSearchPlaceIndexForSuggestionsRequestString
        extends Subtype[String]
    type SyntheticSearchPlaceIndexForSuggestionsRequestString =
      zio.aws.location.model.primitives.SyntheticSearchPlaceIndexForSuggestionsRequestString.Type
    object SyntheticSearchPlaceIndexForSuggestionsSummaryString
        extends Subtype[String]
    type SyntheticSearchPlaceIndexForSuggestionsSummaryString =
      zio.aws.location.model.primitives.SyntheticSearchPlaceIndexForSuggestionsSummaryString.Type
    object SyntheticSearchPlaceIndexForTextRequestString extends Subtype[String]
    type SyntheticSearchPlaceIndexForTextRequestString =
      zio.aws.location.model.primitives.SyntheticSearchPlaceIndexForTextRequestString.Type
    object SyntheticSearchPlaceIndexForTextSummaryString extends Subtype[String]
    type SyntheticSearchPlaceIndexForTextSummaryString =
      zio.aws.location.model.primitives.SyntheticSearchPlaceIndexForTextSummaryString.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.location.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.location.model.primitives.TagValue.Type
    object Timestamp extends Subtype[Instant]
    type Timestamp = zio.aws.location.model.primitives.Timestamp.Type
    object Token extends Subtype[String]
    type Token = zio.aws.location.model.primitives.Token.Type
    object TruckDimensionsHeightDouble extends Subtype[Double]
    type TruckDimensionsHeightDouble =
      zio.aws.location.model.primitives.TruckDimensionsHeightDouble.Type
    object TruckDimensionsLengthDouble extends Subtype[Double]
    type TruckDimensionsLengthDouble =
      zio.aws.location.model.primitives.TruckDimensionsLengthDouble.Type
    object TruckDimensionsWidthDouble extends Subtype[Double]
    type TruckDimensionsWidthDouble =
      zio.aws.location.model.primitives.TruckDimensionsWidthDouble.Type
    object TruckWeightTotalDouble extends Subtype[Double]
    type TruckWeightTotalDouble =
      zio.aws.location.model.primitives.TruckWeightTotalDouble.Type
  }
  type ArnList = List[Arn]
  type BatchDeleteDevicePositionHistoryErrorList =
    List[zio.aws.location.model.BatchDeleteDevicePositionHistoryError]
  type BatchDeleteDevicePositionHistoryRequestDeviceIdsList = List[Id]
  type BatchDeleteGeofenceErrorList =
    List[zio.aws.location.model.BatchDeleteGeofenceError]
  type BatchDeleteGeofenceRequestGeofenceIdsList = List[Id]
  type BatchEvaluateGeofencesErrorList =
    List[zio.aws.location.model.BatchEvaluateGeofencesError]
  type BatchEvaluateGeofencesRequestDevicePositionUpdatesList =
    List[zio.aws.location.model.DevicePositionUpdate]
  type BatchGetDevicePositionErrorList =
    List[zio.aws.location.model.BatchGetDevicePositionError]
  type BatchGetDevicePositionRequestDeviceIdsList = List[Id]
  type BatchPutGeofenceErrorList =
    List[zio.aws.location.model.BatchPutGeofenceError]
  type BatchPutGeofenceRequestEntriesList =
    List[zio.aws.location.model.BatchPutGeofenceRequestEntry]
  type BatchPutGeofenceSuccessList =
    List[zio.aws.location.model.BatchPutGeofenceSuccess]
  type BatchUpdateDevicePositionErrorList =
    List[zio.aws.location.model.BatchUpdateDevicePositionError]
  type BatchUpdateDevicePositionRequestUpdatesList =
    List[zio.aws.location.model.DevicePositionUpdate]
  type BoundingBox = List[Double]
  type CalculateRouteMatrixRequestDeparturePositionsList =
    List[Iterable[Double]]
  type CalculateRouteMatrixRequestDestinationPositionsList =
    List[Iterable[Double]]
  type CalculateRouteMatrixResponseSnappedDeparturePositionsList =
    List[Iterable[Double]]
  type CalculateRouteMatrixResponseSnappedDestinationPositionsList =
    List[Iterable[Double]]
  type CalculateRouteRequestWaypointPositionsList = List[Iterable[Double]]
  type CountryCodeList = List[CountryCode]
  type DevicePositionList = List[zio.aws.location.model.DevicePosition]
  type LegList = List[zio.aws.location.model.Leg]
  type LineString = List[Iterable[Double]]
  type LinearRing = List[Iterable[Double]]
  type LinearRings = List[Iterable[Iterable[Double]]]
  type ListDevicePositionsResponseEntryList =
    List[zio.aws.location.model.ListDevicePositionsResponseEntry]
  type ListGeofenceCollectionsResponseEntryList =
    List[zio.aws.location.model.ListGeofenceCollectionsResponseEntry]
  type ListGeofenceResponseEntryList =
    List[zio.aws.location.model.ListGeofenceResponseEntry]
  type ListMapsResponseEntryList =
    List[zio.aws.location.model.ListMapsResponseEntry]
  type ListPlaceIndexesResponseEntryList =
    List[zio.aws.location.model.ListPlaceIndexesResponseEntry]
  type ListRouteCalculatorsResponseEntryList =
    List[zio.aws.location.model.ListRouteCalculatorsResponseEntry]
  type ListTrackersResponseEntryList =
    List[zio.aws.location.model.ListTrackersResponseEntry]
  type Position = List[Double]
  type PropertyMap = Map[PropertyMapKeyString, PropertyMapValueString]
  type RouteMatrix = List[Iterable[zio.aws.location.model.RouteMatrixEntry]]
  type RouteMatrixRow = List[zio.aws.location.model.RouteMatrixEntry]
  type SearchForPositionResultList =
    List[zio.aws.location.model.SearchForPositionResult]
  type SearchForSuggestionsResultList =
    List[zio.aws.location.model.SearchForSuggestionsResult]
  type SearchForTextResultList =
    List[zio.aws.location.model.SearchForTextResult]
  type StepList = List[zio.aws.location.model.Step]
  type TagKeys = List[String]
  type TagMap = Map[TagKey, TagValue]
}
