package zio.aws.location
import zio.aws.location.model.ListDevicePositionsResponse.ReadOnly
import zio.aws.location.model.primitives.Arn
import zio.aws.core.config.AwsConfig
import zio.aws.core.{AwsServiceBase, AwsError}
import software.amazon.awssdk.services.location.model.{
  ListGeofencesResponse,
  ListGeofenceCollectionsResponseEntry,
  CreateGeofenceCollectionRequest,
  ListMapsResponse,
  GetMapSpritesRequest,
  DescribeGeofenceCollectionRequest,
  UpdateTrackerRequest,
  DeleteMapResponse,
  UpdateMapRequest,
  UpdateGeofenceCollectionResponse,
  SearchPlaceIndexForTextRequest,
  BatchDeleteDevicePositionHistoryRequest,
  GetMapGlyphsResponse,
  GetMapStyleDescriptorRequest,
  BatchUpdateDevicePositionRequest,
  DeletePlaceIndexRequest,
  CreateTrackerResponse,
  GetGeofenceResponse,
  UpdateRouteCalculatorRequest,
  DeleteTrackerResponse,
  SearchPlaceIndexForSuggestionsResponse,
  SearchPlaceIndexForSuggestionsRequest,
  GetMapStyleDescriptorResponse,
  PutGeofenceRequest,
  CalculateRouteMatrixRequest,
  GetGeofenceRequest,
  CreateRouteCalculatorResponse,
  DescribeGeofenceCollectionResponse,
  ListGeofenceResponseEntry,
  UpdateMapResponse,
  ListRouteCalculatorsResponseEntry,
  BatchPutGeofenceRequest,
  CreateMapRequest,
  DisassociateTrackerConsumerResponse,
  DeletePlaceIndexResponse,
  DescribeRouteCalculatorRequest,
  DevicePosition,
  ListRouteCalculatorsResponse,
  ListPlaceIndexesResponse,
  GetMapSpritesResponse,
  ListTagsForResourceRequest,
  SearchPlaceIndexForPositionResponse,
  BatchEvaluateGeofencesRequest,
  UpdateTrackerResponse,
  BatchGetDevicePositionResponse,
  ListTrackersResponse,
  DisassociateTrackerConsumerRequest,
  ListPlaceIndexesResponseEntry,
  PutGeofenceResponse,
  BatchEvaluateGeofencesResponse,
  BatchPutGeofenceResponse,
  GetMapTileResponse,
  ListTagsForResourceResponse,
  UntagResourceResponse,
  ListGeofenceCollectionsResponse,
  GetDevicePositionHistoryRequest,
  DescribePlaceIndexRequest,
  CreateTrackerRequest,
  ListMapsRequest,
  GetDevicePositionResponse,
  DeleteRouteCalculatorRequest,
  DeleteGeofenceCollectionResponse,
  BatchGetDevicePositionRequest,
  ListTrackersRequest,
  CreateGeofenceCollectionResponse,
  ListMapsResponseEntry,
  UpdateRouteCalculatorResponse,
  ListDevicePositionsResponse,
  BatchDeleteGeofenceRequest,
  ListRouteCalculatorsRequest,
  SearchPlaceIndexForTextResponse,
  GetDevicePositionRequest,
  AssociateTrackerConsumerResponse,
  UpdatePlaceIndexResponse,
  ListDevicePositionsResponseEntry,
  CalculateRouteResponse,
  UntagResourceRequest,
  BatchDeleteGeofenceResponse,
  UpdatePlaceIndexRequest,
  DeleteRouteCalculatorResponse,
  ListTrackerConsumersRequest,
  ListTrackersResponseEntry,
  CalculateRouteMatrixResponse,
  ListDevicePositionsRequest,
  DescribeRouteCalculatorResponse,
  UpdateGeofenceCollectionRequest,
  AssociateTrackerConsumerRequest,
  GetMapTileRequest,
  BatchDeleteDevicePositionHistoryResponse,
  DeleteMapRequest,
  DescribeTrackerRequest,
  GetDevicePositionHistoryResponse,
  DeleteTrackerRequest,
  CalculateRouteRequest,
  CreatePlaceIndexRequest,
  ListGeofenceCollectionsRequest,
  CreateMapResponse,
  TagResourceResponse,
  ListPlaceIndexesRequest,
  SearchPlaceIndexForPositionRequest,
  ListGeofencesRequest,
  CreatePlaceIndexResponse,
  DescribePlaceIndexResponse,
  BatchUpdateDevicePositionResponse,
  DeleteGeofenceCollectionRequest,
  CreateRouteCalculatorRequest,
  TagResourceRequest,
  ListTrackerConsumersResponse,
  DescribeMapResponse,
  DescribeTrackerResponse,
  DescribeMapRequest,
  GetMapGlyphsRequest
}
import software.amazon.awssdk.services.location.{
  LocationAsyncClientBuilder,
  LocationAsyncClient
}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import zio.stream.ZStream
import scala.jdk.CollectionConverters._
trait Location extends AspectSupport[Location] {
  val api: LocationAsyncClient
  def listMaps(request: zio.aws.location.model.ListMapsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.location.model.ListMapsResponseEntry.ReadOnly
  ]
  def listMapsPaginated(
      request: zio.aws.location.model.ListMapsRequest
  ): IO[AwsError, zio.aws.location.model.ListMapsResponse.ReadOnly]
  def getMapTile(
      request: zio.aws.location.model.GetMapTileRequest
  ): IO[AwsError, zio.aws.location.model.GetMapTileResponse.ReadOnly]
  def describeTracker(
      request: zio.aws.location.model.DescribeTrackerRequest
  ): IO[AwsError, zio.aws.location.model.DescribeTrackerResponse.ReadOnly]
  def deleteMap(
      request: zio.aws.location.model.DeleteMapRequest
  ): IO[AwsError, zio.aws.location.model.DeleteMapResponse.ReadOnly]
  def updateGeofenceCollection(
      request: zio.aws.location.model.UpdateGeofenceCollectionRequest
  ): IO[
    AwsError,
    zio.aws.location.model.UpdateGeofenceCollectionResponse.ReadOnly
  ]
  def deleteTracker(
      request: zio.aws.location.model.DeleteTrackerRequest
  ): IO[AwsError, zio.aws.location.model.DeleteTrackerResponse.ReadOnly]
  def listPlaceIndexes(
      request: zio.aws.location.model.ListPlaceIndexesRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.location.model.ListPlaceIndexesResponseEntry.ReadOnly
  ]
  def listPlaceIndexesPaginated(
      request: zio.aws.location.model.ListPlaceIndexesRequest
  ): IO[AwsError, zio.aws.location.model.ListPlaceIndexesResponse.ReadOnly]
  def getMapGlyphs(
      request: zio.aws.location.model.GetMapGlyphsRequest
  ): IO[AwsError, zio.aws.location.model.GetMapGlyphsResponse.ReadOnly]
  def batchEvaluateGeofences(
      request: zio.aws.location.model.BatchEvaluateGeofencesRequest
  ): IO[
    AwsError,
    zio.aws.location.model.BatchEvaluateGeofencesResponse.ReadOnly
  ]
  def deletePlaceIndex(
      request: zio.aws.location.model.DeletePlaceIndexRequest
  ): IO[AwsError, zio.aws.location.model.DeletePlaceIndexResponse.ReadOnly]
  def describeRouteCalculator(
      request: zio.aws.location.model.DescribeRouteCalculatorRequest
  ): IO[
    AwsError,
    zio.aws.location.model.DescribeRouteCalculatorResponse.ReadOnly
  ]
  def calculateRouteMatrix(
      request: zio.aws.location.model.CalculateRouteMatrixRequest
  ): IO[AwsError, zio.aws.location.model.CalculateRouteMatrixResponse.ReadOnly]
  def putGeofence(
      request: zio.aws.location.model.PutGeofenceRequest
  ): IO[AwsError, zio.aws.location.model.PutGeofenceResponse.ReadOnly]
  def deleteGeofenceCollection(
      request: zio.aws.location.model.DeleteGeofenceCollectionRequest
  ): IO[
    AwsError,
    zio.aws.location.model.DeleteGeofenceCollectionResponse.ReadOnly
  ]
  def searchPlaceIndexForText(
      request: zio.aws.location.model.SearchPlaceIndexForTextRequest
  ): IO[
    AwsError,
    zio.aws.location.model.SearchPlaceIndexForTextResponse.ReadOnly
  ]
  def createRouteCalculator(
      request: zio.aws.location.model.CreateRouteCalculatorRequest
  ): IO[AwsError, zio.aws.location.model.CreateRouteCalculatorResponse.ReadOnly]
  def searchPlaceIndexForPosition(
      request: zio.aws.location.model.SearchPlaceIndexForPositionRequest
  ): IO[
    AwsError,
    zio.aws.location.model.SearchPlaceIndexForPositionResponse.ReadOnly
  ]
  def associateTrackerConsumer(
      request: zio.aws.location.model.AssociateTrackerConsumerRequest
  ): IO[
    AwsError,
    zio.aws.location.model.AssociateTrackerConsumerResponse.ReadOnly
  ]
  def batchDeleteDevicePositionHistory(
      request: zio.aws.location.model.BatchDeleteDevicePositionHistoryRequest
  ): IO[
    AwsError,
    zio.aws.location.model.BatchDeleteDevicePositionHistoryResponse.ReadOnly
  ]
  def calculateRoute(
      request: zio.aws.location.model.CalculateRouteRequest
  ): IO[AwsError, zio.aws.location.model.CalculateRouteResponse.ReadOnly]
  def createGeofenceCollection(
      request: zio.aws.location.model.CreateGeofenceCollectionRequest
  ): IO[
    AwsError,
    zio.aws.location.model.CreateGeofenceCollectionResponse.ReadOnly
  ]
  def getGeofence(
      request: zio.aws.location.model.GetGeofenceRequest
  ): IO[AwsError, zio.aws.location.model.GetGeofenceResponse.ReadOnly]
  def describeGeofenceCollection(
      request: zio.aws.location.model.DescribeGeofenceCollectionRequest
  ): IO[
    AwsError,
    zio.aws.location.model.DescribeGeofenceCollectionResponse.ReadOnly
  ]
  def searchPlaceIndexForSuggestions(
      request: zio.aws.location.model.SearchPlaceIndexForSuggestionsRequest
  ): IO[
    AwsError,
    zio.aws.location.model.SearchPlaceIndexForSuggestionsResponse.ReadOnly
  ]
  def updateMap(
      request: zio.aws.location.model.UpdateMapRequest
  ): IO[AwsError, zio.aws.location.model.UpdateMapResponse.ReadOnly]
  def deleteRouteCalculator(
      request: zio.aws.location.model.DeleteRouteCalculatorRequest
  ): IO[AwsError, zio.aws.location.model.DeleteRouteCalculatorResponse.ReadOnly]
  def getMapStyleDescriptor(
      request: zio.aws.location.model.GetMapStyleDescriptorRequest
  ): IO[AwsError, zio.aws.location.model.GetMapStyleDescriptorResponse.ReadOnly]
  def untagResource(
      request: zio.aws.location.model.UntagResourceRequest
  ): IO[AwsError, zio.aws.location.model.UntagResourceResponse.ReadOnly]
  def disassociateTrackerConsumer(
      request: zio.aws.location.model.DisassociateTrackerConsumerRequest
  ): IO[
    AwsError,
    zio.aws.location.model.DisassociateTrackerConsumerResponse.ReadOnly
  ]
  def getDevicePositionHistory(
      request: zio.aws.location.model.GetDevicePositionHistoryRequest
  ): ZStream[Any, AwsError, zio.aws.location.model.DevicePosition.ReadOnly]
  def getDevicePositionHistoryPaginated(
      request: zio.aws.location.model.GetDevicePositionHistoryRequest
  ): IO[
    AwsError,
    zio.aws.location.model.GetDevicePositionHistoryResponse.ReadOnly
  ]
  def batchGetDevicePosition(
      request: zio.aws.location.model.BatchGetDevicePositionRequest
  ): IO[
    AwsError,
    zio.aws.location.model.BatchGetDevicePositionResponse.ReadOnly
  ]
  def listGeofenceCollections(
      request: zio.aws.location.model.ListGeofenceCollectionsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.location.model.ListGeofenceCollectionsResponseEntry.ReadOnly
  ]
  def listGeofenceCollectionsPaginated(
      request: zio.aws.location.model.ListGeofenceCollectionsRequest
  ): IO[
    AwsError,
    zio.aws.location.model.ListGeofenceCollectionsResponse.ReadOnly
  ]
  def describePlaceIndex(
      request: zio.aws.location.model.DescribePlaceIndexRequest
  ): IO[AwsError, zio.aws.location.model.DescribePlaceIndexResponse.ReadOnly]
  def updatePlaceIndex(
      request: zio.aws.location.model.UpdatePlaceIndexRequest
  ): IO[AwsError, zio.aws.location.model.UpdatePlaceIndexResponse.ReadOnly]
  def getMapSprites(
      request: zio.aws.location.model.GetMapSpritesRequest
  ): IO[AwsError, zio.aws.location.model.GetMapSpritesResponse.ReadOnly]
  def listRouteCalculators(
      request: zio.aws.location.model.ListRouteCalculatorsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.location.model.ListRouteCalculatorsResponseEntry.ReadOnly
  ]
  def listRouteCalculatorsPaginated(
      request: zio.aws.location.model.ListRouteCalculatorsRequest
  ): IO[AwsError, zio.aws.location.model.ListRouteCalculatorsResponse.ReadOnly]
  def batchUpdateDevicePosition(
      request: zio.aws.location.model.BatchUpdateDevicePositionRequest
  ): IO[
    AwsError,
    zio.aws.location.model.BatchUpdateDevicePositionResponse.ReadOnly
  ]
  def listTagsForResource(
      request: zio.aws.location.model.ListTagsForResourceRequest
  ): IO[AwsError, zio.aws.location.model.ListTagsForResourceResponse.ReadOnly]
  def listTrackerConsumers(
      request: zio.aws.location.model.ListTrackerConsumersRequest
  ): ZStream[Any, AwsError, Arn]
  def listTrackerConsumersPaginated(
      request: zio.aws.location.model.ListTrackerConsumersRequest
  ): IO[AwsError, zio.aws.location.model.ListTrackerConsumersResponse.ReadOnly]
  def createPlaceIndex(
      request: zio.aws.location.model.CreatePlaceIndexRequest
  ): IO[AwsError, zio.aws.location.model.CreatePlaceIndexResponse.ReadOnly]
  def updateRouteCalculator(
      request: zio.aws.location.model.UpdateRouteCalculatorRequest
  ): IO[AwsError, zio.aws.location.model.UpdateRouteCalculatorResponse.ReadOnly]
  def describeMap(
      request: zio.aws.location.model.DescribeMapRequest
  ): IO[AwsError, zio.aws.location.model.DescribeMapResponse.ReadOnly]
  def tagResource(
      request: zio.aws.location.model.TagResourceRequest
  ): IO[AwsError, zio.aws.location.model.TagResourceResponse.ReadOnly]
  def createTracker(
      request: zio.aws.location.model.CreateTrackerRequest
  ): IO[AwsError, zio.aws.location.model.CreateTrackerResponse.ReadOnly]
  def createMap(
      request: zio.aws.location.model.CreateMapRequest
  ): IO[AwsError, zio.aws.location.model.CreateMapResponse.ReadOnly]
  def listTrackers(
      request: zio.aws.location.model.ListTrackersRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.location.model.ListTrackersResponseEntry.ReadOnly
  ]
  def listTrackersPaginated(
      request: zio.aws.location.model.ListTrackersRequest
  ): IO[AwsError, zio.aws.location.model.ListTrackersResponse.ReadOnly]
  def listDevicePositions(
      request: zio.aws.location.model.ListDevicePositionsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.location.model.ListDevicePositionsResponseEntry.ReadOnly
  ]
  def listDevicePositionsPaginated(
      request: zio.aws.location.model.ListDevicePositionsRequest
  ): IO[AwsError, ReadOnly]
  def updateTracker(
      request: zio.aws.location.model.UpdateTrackerRequest
  ): IO[AwsError, zio.aws.location.model.UpdateTrackerResponse.ReadOnly]
  def getDevicePosition(
      request: zio.aws.location.model.GetDevicePositionRequest
  ): IO[AwsError, zio.aws.location.model.GetDevicePositionResponse.ReadOnly]
  def listGeofences(
      request: zio.aws.location.model.ListGeofencesRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.location.model.ListGeofenceResponseEntry.ReadOnly
  ]
  def listGeofencesPaginated(
      request: zio.aws.location.model.ListGeofencesRequest
  ): IO[AwsError, zio.aws.location.model.ListGeofencesResponse.ReadOnly]
  def batchDeleteGeofence(
      request: zio.aws.location.model.BatchDeleteGeofenceRequest
  ): IO[AwsError, zio.aws.location.model.BatchDeleteGeofenceResponse.ReadOnly]
  def batchPutGeofence(
      request: zio.aws.location.model.BatchPutGeofenceRequest
  ): IO[AwsError, zio.aws.location.model.BatchPutGeofenceResponse.ReadOnly]
}
object Location {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Location] = customized(
    identity
  )
  def customized(
      customization: LocationAsyncClientBuilder => LocationAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Location] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: LocationAsyncClientBuilder => LocationAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, Location] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = LocationAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[LocationAsyncClient, LocationAsyncClientBuilder](
      builder
    );
    b1 <- awsConfig
      .configureHttpClient[LocationAsyncClient, LocationAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      ); client <- ZIO.attempt(customization(b1).build())
  ) yield new LocationImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class LocationImpl[R](
      override val api: LocationAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Location
      with AwsServiceBase[R] {
    override val serviceName: String = "Location"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): LocationImpl[R1] = new LocationImpl(api, newAspect, r)
    def listMaps(request: zio.aws.location.model.ListMapsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.location.model.ListMapsResponseEntry.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListMapsRequest,
      ListMapsResponse,
      ListMapsResponseEntry
    ](
      "listMaps",
      api.listMaps,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.entries().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.location.model.ListMapsResponseEntry.wrap(item))
      .provideEnvironment(r)
    def listMapsPaginated(
        request: zio.aws.location.model.ListMapsRequest
    ): IO[AwsError, zio.aws.location.model.ListMapsResponse.ReadOnly] =
      asyncRequestResponse[ListMapsRequest, ListMapsResponse](
        "listMaps",
        api.listMaps
      )(request.buildAwsValue())
        .map(zio.aws.location.model.ListMapsResponse.wrap)
        .provideEnvironment(r)
    def getMapTile(
        request: zio.aws.location.model.GetMapTileRequest
    ): IO[AwsError, zio.aws.location.model.GetMapTileResponse.ReadOnly] =
      asyncRequestResponse[GetMapTileRequest, GetMapTileResponse](
        "getMapTile",
        api.getMapTile
      )(request.buildAwsValue())
        .map(zio.aws.location.model.GetMapTileResponse.wrap)
        .provideEnvironment(r)
    def describeTracker(
        request: zio.aws.location.model.DescribeTrackerRequest
    ): IO[AwsError, zio.aws.location.model.DescribeTrackerResponse.ReadOnly] =
      asyncRequestResponse[DescribeTrackerRequest, DescribeTrackerResponse](
        "describeTracker",
        api.describeTracker
      )(request.buildAwsValue())
        .map(zio.aws.location.model.DescribeTrackerResponse.wrap)
        .provideEnvironment(r)
    def deleteMap(
        request: zio.aws.location.model.DeleteMapRequest
    ): IO[AwsError, zio.aws.location.model.DeleteMapResponse.ReadOnly] =
      asyncRequestResponse[DeleteMapRequest, DeleteMapResponse](
        "deleteMap",
        api.deleteMap
      )(request.buildAwsValue())
        .map(zio.aws.location.model.DeleteMapResponse.wrap)
        .provideEnvironment(r)
    def updateGeofenceCollection(
        request: zio.aws.location.model.UpdateGeofenceCollectionRequest
    ): IO[
      AwsError,
      zio.aws.location.model.UpdateGeofenceCollectionResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateGeofenceCollectionRequest,
      UpdateGeofenceCollectionResponse
    ]("updateGeofenceCollection", api.updateGeofenceCollection)(
      request.buildAwsValue()
    ).map(zio.aws.location.model.UpdateGeofenceCollectionResponse.wrap)
      .provideEnvironment(r)
    def deleteTracker(
        request: zio.aws.location.model.DeleteTrackerRequest
    ): IO[AwsError, zio.aws.location.model.DeleteTrackerResponse.ReadOnly] =
      asyncRequestResponse[DeleteTrackerRequest, DeleteTrackerResponse](
        "deleteTracker",
        api.deleteTracker
      )(request.buildAwsValue())
        .map(zio.aws.location.model.DeleteTrackerResponse.wrap)
        .provideEnvironment(r)
    def listPlaceIndexes(
        request: zio.aws.location.model.ListPlaceIndexesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.location.model.ListPlaceIndexesResponseEntry.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListPlaceIndexesRequest,
      ListPlaceIndexesResponse,
      ListPlaceIndexesResponseEntry
    ](
      "listPlaceIndexes",
      api.listPlaceIndexes,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.entries().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.location.model.ListPlaceIndexesResponseEntry.wrap(item)
      )
      .provideEnvironment(r)
    def listPlaceIndexesPaginated(
        request: zio.aws.location.model.ListPlaceIndexesRequest
    ): IO[AwsError, zio.aws.location.model.ListPlaceIndexesResponse.ReadOnly] =
      asyncRequestResponse[ListPlaceIndexesRequest, ListPlaceIndexesResponse](
        "listPlaceIndexes",
        api.listPlaceIndexes
      )(request.buildAwsValue())
        .map(zio.aws.location.model.ListPlaceIndexesResponse.wrap)
        .provideEnvironment(r)
    def getMapGlyphs(
        request: zio.aws.location.model.GetMapGlyphsRequest
    ): IO[AwsError, zio.aws.location.model.GetMapGlyphsResponse.ReadOnly] =
      asyncRequestResponse[GetMapGlyphsRequest, GetMapGlyphsResponse](
        "getMapGlyphs",
        api.getMapGlyphs
      )(request.buildAwsValue())
        .map(zio.aws.location.model.GetMapGlyphsResponse.wrap)
        .provideEnvironment(r)
    def batchEvaluateGeofences(
        request: zio.aws.location.model.BatchEvaluateGeofencesRequest
    ): IO[
      AwsError,
      zio.aws.location.model.BatchEvaluateGeofencesResponse.ReadOnly
    ] = asyncRequestResponse[
      BatchEvaluateGeofencesRequest,
      BatchEvaluateGeofencesResponse
    ]("batchEvaluateGeofences", api.batchEvaluateGeofences)(
      request.buildAwsValue()
    ).map(zio.aws.location.model.BatchEvaluateGeofencesResponse.wrap)
      .provideEnvironment(r)
    def deletePlaceIndex(
        request: zio.aws.location.model.DeletePlaceIndexRequest
    ): IO[AwsError, zio.aws.location.model.DeletePlaceIndexResponse.ReadOnly] =
      asyncRequestResponse[DeletePlaceIndexRequest, DeletePlaceIndexResponse](
        "deletePlaceIndex",
        api.deletePlaceIndex
      )(request.buildAwsValue())
        .map(zio.aws.location.model.DeletePlaceIndexResponse.wrap)
        .provideEnvironment(r)
    def describeRouteCalculator(
        request: zio.aws.location.model.DescribeRouteCalculatorRequest
    ): IO[
      AwsError,
      zio.aws.location.model.DescribeRouteCalculatorResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeRouteCalculatorRequest,
      DescribeRouteCalculatorResponse
    ]("describeRouteCalculator", api.describeRouteCalculator)(
      request.buildAwsValue()
    ).map(zio.aws.location.model.DescribeRouteCalculatorResponse.wrap)
      .provideEnvironment(r)
    def calculateRouteMatrix(
        request: zio.aws.location.model.CalculateRouteMatrixRequest
    ): IO[
      AwsError,
      zio.aws.location.model.CalculateRouteMatrixResponse.ReadOnly
    ] = asyncRequestResponse[
      CalculateRouteMatrixRequest,
      CalculateRouteMatrixResponse
    ]("calculateRouteMatrix", api.calculateRouteMatrix)(request.buildAwsValue())
      .map(zio.aws.location.model.CalculateRouteMatrixResponse.wrap)
      .provideEnvironment(r)
    def putGeofence(
        request: zio.aws.location.model.PutGeofenceRequest
    ): IO[AwsError, zio.aws.location.model.PutGeofenceResponse.ReadOnly] =
      asyncRequestResponse[PutGeofenceRequest, PutGeofenceResponse](
        "putGeofence",
        api.putGeofence
      )(request.buildAwsValue())
        .map(zio.aws.location.model.PutGeofenceResponse.wrap)
        .provideEnvironment(r)
    def deleteGeofenceCollection(
        request: zio.aws.location.model.DeleteGeofenceCollectionRequest
    ): IO[
      AwsError,
      zio.aws.location.model.DeleteGeofenceCollectionResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteGeofenceCollectionRequest,
      DeleteGeofenceCollectionResponse
    ]("deleteGeofenceCollection", api.deleteGeofenceCollection)(
      request.buildAwsValue()
    ).map(zio.aws.location.model.DeleteGeofenceCollectionResponse.wrap)
      .provideEnvironment(r)
    def searchPlaceIndexForText(
        request: zio.aws.location.model.SearchPlaceIndexForTextRequest
    ): IO[
      AwsError,
      zio.aws.location.model.SearchPlaceIndexForTextResponse.ReadOnly
    ] = asyncRequestResponse[
      SearchPlaceIndexForTextRequest,
      SearchPlaceIndexForTextResponse
    ]("searchPlaceIndexForText", api.searchPlaceIndexForText)(
      request.buildAwsValue()
    ).map(zio.aws.location.model.SearchPlaceIndexForTextResponse.wrap)
      .provideEnvironment(r)
    def createRouteCalculator(
        request: zio.aws.location.model.CreateRouteCalculatorRequest
    ): IO[
      AwsError,
      zio.aws.location.model.CreateRouteCalculatorResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateRouteCalculatorRequest,
      CreateRouteCalculatorResponse
    ]("createRouteCalculator", api.createRouteCalculator)(
      request.buildAwsValue()
    ).map(zio.aws.location.model.CreateRouteCalculatorResponse.wrap)
      .provideEnvironment(r)
    def searchPlaceIndexForPosition(
        request: zio.aws.location.model.SearchPlaceIndexForPositionRequest
    ): IO[
      AwsError,
      zio.aws.location.model.SearchPlaceIndexForPositionResponse.ReadOnly
    ] = asyncRequestResponse[
      SearchPlaceIndexForPositionRequest,
      SearchPlaceIndexForPositionResponse
    ]("searchPlaceIndexForPosition", api.searchPlaceIndexForPosition)(
      request.buildAwsValue()
    ).map(zio.aws.location.model.SearchPlaceIndexForPositionResponse.wrap)
      .provideEnvironment(r)
    def associateTrackerConsumer(
        request: zio.aws.location.model.AssociateTrackerConsumerRequest
    ): IO[
      AwsError,
      zio.aws.location.model.AssociateTrackerConsumerResponse.ReadOnly
    ] = asyncRequestResponse[
      AssociateTrackerConsumerRequest,
      AssociateTrackerConsumerResponse
    ]("associateTrackerConsumer", api.associateTrackerConsumer)(
      request.buildAwsValue()
    ).map(zio.aws.location.model.AssociateTrackerConsumerResponse.wrap)
      .provideEnvironment(r)
    def batchDeleteDevicePositionHistory(
        request: zio.aws.location.model.BatchDeleteDevicePositionHistoryRequest
    ): IO[
      AwsError,
      zio.aws.location.model.BatchDeleteDevicePositionHistoryResponse.ReadOnly
    ] = asyncRequestResponse[
      BatchDeleteDevicePositionHistoryRequest,
      BatchDeleteDevicePositionHistoryResponse
    ]("batchDeleteDevicePositionHistory", api.batchDeleteDevicePositionHistory)(
      request.buildAwsValue()
    ).map(zio.aws.location.model.BatchDeleteDevicePositionHistoryResponse.wrap)
      .provideEnvironment(r)
    def calculateRoute(
        request: zio.aws.location.model.CalculateRouteRequest
    ): IO[AwsError, zio.aws.location.model.CalculateRouteResponse.ReadOnly] =
      asyncRequestResponse[CalculateRouteRequest, CalculateRouteResponse](
        "calculateRoute",
        api.calculateRoute
      )(request.buildAwsValue())
        .map(zio.aws.location.model.CalculateRouteResponse.wrap)
        .provideEnvironment(r)
    def createGeofenceCollection(
        request: zio.aws.location.model.CreateGeofenceCollectionRequest
    ): IO[
      AwsError,
      zio.aws.location.model.CreateGeofenceCollectionResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateGeofenceCollectionRequest,
      CreateGeofenceCollectionResponse
    ]("createGeofenceCollection", api.createGeofenceCollection)(
      request.buildAwsValue()
    ).map(zio.aws.location.model.CreateGeofenceCollectionResponse.wrap)
      .provideEnvironment(r)
    def getGeofence(
        request: zio.aws.location.model.GetGeofenceRequest
    ): IO[AwsError, zio.aws.location.model.GetGeofenceResponse.ReadOnly] =
      asyncRequestResponse[GetGeofenceRequest, GetGeofenceResponse](
        "getGeofence",
        api.getGeofence
      )(request.buildAwsValue())
        .map(zio.aws.location.model.GetGeofenceResponse.wrap)
        .provideEnvironment(r)
    def describeGeofenceCollection(
        request: zio.aws.location.model.DescribeGeofenceCollectionRequest
    ): IO[
      AwsError,
      zio.aws.location.model.DescribeGeofenceCollectionResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeGeofenceCollectionRequest,
      DescribeGeofenceCollectionResponse
    ]("describeGeofenceCollection", api.describeGeofenceCollection)(
      request.buildAwsValue()
    ).map(zio.aws.location.model.DescribeGeofenceCollectionResponse.wrap)
      .provideEnvironment(r)
    def searchPlaceIndexForSuggestions(
        request: zio.aws.location.model.SearchPlaceIndexForSuggestionsRequest
    ): IO[
      AwsError,
      zio.aws.location.model.SearchPlaceIndexForSuggestionsResponse.ReadOnly
    ] = asyncRequestResponse[
      SearchPlaceIndexForSuggestionsRequest,
      SearchPlaceIndexForSuggestionsResponse
    ]("searchPlaceIndexForSuggestions", api.searchPlaceIndexForSuggestions)(
      request.buildAwsValue()
    ).map(zio.aws.location.model.SearchPlaceIndexForSuggestionsResponse.wrap)
      .provideEnvironment(r)
    def updateMap(
        request: zio.aws.location.model.UpdateMapRequest
    ): IO[AwsError, zio.aws.location.model.UpdateMapResponse.ReadOnly] =
      asyncRequestResponse[UpdateMapRequest, UpdateMapResponse](
        "updateMap",
        api.updateMap
      )(request.buildAwsValue())
        .map(zio.aws.location.model.UpdateMapResponse.wrap)
        .provideEnvironment(r)
    def deleteRouteCalculator(
        request: zio.aws.location.model.DeleteRouteCalculatorRequest
    ): IO[
      AwsError,
      zio.aws.location.model.DeleteRouteCalculatorResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteRouteCalculatorRequest,
      DeleteRouteCalculatorResponse
    ]("deleteRouteCalculator", api.deleteRouteCalculator)(
      request.buildAwsValue()
    ).map(zio.aws.location.model.DeleteRouteCalculatorResponse.wrap)
      .provideEnvironment(r)
    def getMapStyleDescriptor(
        request: zio.aws.location.model.GetMapStyleDescriptorRequest
    ): IO[
      AwsError,
      zio.aws.location.model.GetMapStyleDescriptorResponse.ReadOnly
    ] = asyncRequestResponse[
      GetMapStyleDescriptorRequest,
      GetMapStyleDescriptorResponse
    ]("getMapStyleDescriptor", api.getMapStyleDescriptor)(
      request.buildAwsValue()
    ).map(zio.aws.location.model.GetMapStyleDescriptorResponse.wrap)
      .provideEnvironment(r)
    def untagResource(
        request: zio.aws.location.model.UntagResourceRequest
    ): IO[AwsError, zio.aws.location.model.UntagResourceResponse.ReadOnly] =
      asyncRequestResponse[UntagResourceRequest, UntagResourceResponse](
        "untagResource",
        api.untagResource
      )(request.buildAwsValue())
        .map(zio.aws.location.model.UntagResourceResponse.wrap)
        .provideEnvironment(r)
    def disassociateTrackerConsumer(
        request: zio.aws.location.model.DisassociateTrackerConsumerRequest
    ): IO[
      AwsError,
      zio.aws.location.model.DisassociateTrackerConsumerResponse.ReadOnly
    ] = asyncRequestResponse[
      DisassociateTrackerConsumerRequest,
      DisassociateTrackerConsumerResponse
    ]("disassociateTrackerConsumer", api.disassociateTrackerConsumer)(
      request.buildAwsValue()
    ).map(zio.aws.location.model.DisassociateTrackerConsumerResponse.wrap)
      .provideEnvironment(r)
    def getDevicePositionHistory(
        request: zio.aws.location.model.GetDevicePositionHistoryRequest
    ): ZStream[Any, AwsError, zio.aws.location.model.DevicePosition.ReadOnly] =
      asyncSimplePaginatedRequest[
        GetDevicePositionHistoryRequest,
        GetDevicePositionHistoryResponse,
        DevicePosition
      ](
        "getDevicePositionHistory",
        api.getDevicePositionHistory,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.devicePositions().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.location.model.DevicePosition.wrap(item))
        .provideEnvironment(r)
    def getDevicePositionHistoryPaginated(
        request: zio.aws.location.model.GetDevicePositionHistoryRequest
    ): IO[
      AwsError,
      zio.aws.location.model.GetDevicePositionHistoryResponse.ReadOnly
    ] = asyncRequestResponse[
      GetDevicePositionHistoryRequest,
      GetDevicePositionHistoryResponse
    ]("getDevicePositionHistory", api.getDevicePositionHistory)(
      request.buildAwsValue()
    ).map(zio.aws.location.model.GetDevicePositionHistoryResponse.wrap)
      .provideEnvironment(r)
    def batchGetDevicePosition(
        request: zio.aws.location.model.BatchGetDevicePositionRequest
    ): IO[
      AwsError,
      zio.aws.location.model.BatchGetDevicePositionResponse.ReadOnly
    ] = asyncRequestResponse[
      BatchGetDevicePositionRequest,
      BatchGetDevicePositionResponse
    ]("batchGetDevicePosition", api.batchGetDevicePosition)(
      request.buildAwsValue()
    ).map(zio.aws.location.model.BatchGetDevicePositionResponse.wrap)
      .provideEnvironment(r)
    def listGeofenceCollections(
        request: zio.aws.location.model.ListGeofenceCollectionsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.location.model.ListGeofenceCollectionsResponseEntry.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListGeofenceCollectionsRequest,
      ListGeofenceCollectionsResponse,
      ListGeofenceCollectionsResponseEntry
    ](
      "listGeofenceCollections",
      api.listGeofenceCollections,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.entries().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.location.model.ListGeofenceCollectionsResponseEntry.wrap(item)
      )
      .provideEnvironment(r)
    def listGeofenceCollectionsPaginated(
        request: zio.aws.location.model.ListGeofenceCollectionsRequest
    ): IO[
      AwsError,
      zio.aws.location.model.ListGeofenceCollectionsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListGeofenceCollectionsRequest,
      ListGeofenceCollectionsResponse
    ]("listGeofenceCollections", api.listGeofenceCollections)(
      request.buildAwsValue()
    ).map(zio.aws.location.model.ListGeofenceCollectionsResponse.wrap)
      .provideEnvironment(r)
    def describePlaceIndex(
        request: zio.aws.location.model.DescribePlaceIndexRequest
    ): IO[
      AwsError,
      zio.aws.location.model.DescribePlaceIndexResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribePlaceIndexRequest,
      DescribePlaceIndexResponse
    ]("describePlaceIndex", api.describePlaceIndex)(request.buildAwsValue())
      .map(zio.aws.location.model.DescribePlaceIndexResponse.wrap)
      .provideEnvironment(r)
    def updatePlaceIndex(
        request: zio.aws.location.model.UpdatePlaceIndexRequest
    ): IO[AwsError, zio.aws.location.model.UpdatePlaceIndexResponse.ReadOnly] =
      asyncRequestResponse[UpdatePlaceIndexRequest, UpdatePlaceIndexResponse](
        "updatePlaceIndex",
        api.updatePlaceIndex
      )(request.buildAwsValue())
        .map(zio.aws.location.model.UpdatePlaceIndexResponse.wrap)
        .provideEnvironment(r)
    def getMapSprites(
        request: zio.aws.location.model.GetMapSpritesRequest
    ): IO[AwsError, zio.aws.location.model.GetMapSpritesResponse.ReadOnly] =
      asyncRequestResponse[GetMapSpritesRequest, GetMapSpritesResponse](
        "getMapSprites",
        api.getMapSprites
      )(request.buildAwsValue())
        .map(zio.aws.location.model.GetMapSpritesResponse.wrap)
        .provideEnvironment(r)
    def listRouteCalculators(
        request: zio.aws.location.model.ListRouteCalculatorsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.location.model.ListRouteCalculatorsResponseEntry.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListRouteCalculatorsRequest,
      ListRouteCalculatorsResponse,
      ListRouteCalculatorsResponseEntry
    ](
      "listRouteCalculators",
      api.listRouteCalculators,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.entries().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.location.model.ListRouteCalculatorsResponseEntry.wrap(item)
      )
      .provideEnvironment(r)
    def listRouteCalculatorsPaginated(
        request: zio.aws.location.model.ListRouteCalculatorsRequest
    ): IO[
      AwsError,
      zio.aws.location.model.ListRouteCalculatorsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListRouteCalculatorsRequest,
      ListRouteCalculatorsResponse
    ]("listRouteCalculators", api.listRouteCalculators)(request.buildAwsValue())
      .map(zio.aws.location.model.ListRouteCalculatorsResponse.wrap)
      .provideEnvironment(r)
    def batchUpdateDevicePosition(
        request: zio.aws.location.model.BatchUpdateDevicePositionRequest
    ): IO[
      AwsError,
      zio.aws.location.model.BatchUpdateDevicePositionResponse.ReadOnly
    ] = asyncRequestResponse[
      BatchUpdateDevicePositionRequest,
      BatchUpdateDevicePositionResponse
    ]("batchUpdateDevicePosition", api.batchUpdateDevicePosition)(
      request.buildAwsValue()
    ).map(zio.aws.location.model.BatchUpdateDevicePositionResponse.wrap)
      .provideEnvironment(r)
    def listTagsForResource(
        request: zio.aws.location.model.ListTagsForResourceRequest
    ): IO[
      AwsError,
      zio.aws.location.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.location.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def listTrackerConsumers(
        request: zio.aws.location.model.ListTrackerConsumersRequest
    ): ZStream[Any, AwsError, Arn] = asyncSimplePaginatedRequest[
      ListTrackerConsumersRequest,
      ListTrackerConsumersResponse,
      java.lang.String
    ](
      "listTrackerConsumers",
      api.listTrackerConsumers,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.consumerArns().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.location.model.primitives.Arn(item))
      .provideEnvironment(r)
    def listTrackerConsumersPaginated(
        request: zio.aws.location.model.ListTrackerConsumersRequest
    ): IO[
      AwsError,
      zio.aws.location.model.ListTrackerConsumersResponse.ReadOnly
    ] = asyncRequestResponse[
      ListTrackerConsumersRequest,
      ListTrackerConsumersResponse
    ]("listTrackerConsumers", api.listTrackerConsumers)(request.buildAwsValue())
      .map(zio.aws.location.model.ListTrackerConsumersResponse.wrap)
      .provideEnvironment(r)
    def createPlaceIndex(
        request: zio.aws.location.model.CreatePlaceIndexRequest
    ): IO[AwsError, zio.aws.location.model.CreatePlaceIndexResponse.ReadOnly] =
      asyncRequestResponse[CreatePlaceIndexRequest, CreatePlaceIndexResponse](
        "createPlaceIndex",
        api.createPlaceIndex
      )(request.buildAwsValue())
        .map(zio.aws.location.model.CreatePlaceIndexResponse.wrap)
        .provideEnvironment(r)
    def updateRouteCalculator(
        request: zio.aws.location.model.UpdateRouteCalculatorRequest
    ): IO[
      AwsError,
      zio.aws.location.model.UpdateRouteCalculatorResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateRouteCalculatorRequest,
      UpdateRouteCalculatorResponse
    ]("updateRouteCalculator", api.updateRouteCalculator)(
      request.buildAwsValue()
    ).map(zio.aws.location.model.UpdateRouteCalculatorResponse.wrap)
      .provideEnvironment(r)
    def describeMap(
        request: zio.aws.location.model.DescribeMapRequest
    ): IO[AwsError, zio.aws.location.model.DescribeMapResponse.ReadOnly] =
      asyncRequestResponse[DescribeMapRequest, DescribeMapResponse](
        "describeMap",
        api.describeMap
      )(request.buildAwsValue())
        .map(zio.aws.location.model.DescribeMapResponse.wrap)
        .provideEnvironment(r)
    def tagResource(
        request: zio.aws.location.model.TagResourceRequest
    ): IO[AwsError, zio.aws.location.model.TagResourceResponse.ReadOnly] =
      asyncRequestResponse[TagResourceRequest, TagResourceResponse](
        "tagResource",
        api.tagResource
      )(request.buildAwsValue())
        .map(zio.aws.location.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def createTracker(
        request: zio.aws.location.model.CreateTrackerRequest
    ): IO[AwsError, zio.aws.location.model.CreateTrackerResponse.ReadOnly] =
      asyncRequestResponse[CreateTrackerRequest, CreateTrackerResponse](
        "createTracker",
        api.createTracker
      )(request.buildAwsValue())
        .map(zio.aws.location.model.CreateTrackerResponse.wrap)
        .provideEnvironment(r)
    def createMap(
        request: zio.aws.location.model.CreateMapRequest
    ): IO[AwsError, zio.aws.location.model.CreateMapResponse.ReadOnly] =
      asyncRequestResponse[CreateMapRequest, CreateMapResponse](
        "createMap",
        api.createMap
      )(request.buildAwsValue())
        .map(zio.aws.location.model.CreateMapResponse.wrap)
        .provideEnvironment(r)
    def listTrackers(
        request: zio.aws.location.model.ListTrackersRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.location.model.ListTrackersResponseEntry.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListTrackersRequest,
      ListTrackersResponse,
      ListTrackersResponseEntry
    ](
      "listTrackers",
      api.listTrackers,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.entries().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.location.model.ListTrackersResponseEntry.wrap(item))
      .provideEnvironment(r)
    def listTrackersPaginated(
        request: zio.aws.location.model.ListTrackersRequest
    ): IO[AwsError, zio.aws.location.model.ListTrackersResponse.ReadOnly] =
      asyncRequestResponse[ListTrackersRequest, ListTrackersResponse](
        "listTrackers",
        api.listTrackers
      )(request.buildAwsValue())
        .map(zio.aws.location.model.ListTrackersResponse.wrap)
        .provideEnvironment(r)
    def listDevicePositions(
        request: zio.aws.location.model.ListDevicePositionsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.location.model.ListDevicePositionsResponseEntry.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListDevicePositionsRequest,
      ListDevicePositionsResponse,
      ListDevicePositionsResponseEntry
    ](
      "listDevicePositions",
      api.listDevicePositions,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.entries().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.location.model.ListDevicePositionsResponseEntry.wrap(item)
      )
      .provideEnvironment(r)
    def listDevicePositionsPaginated(
        request: zio.aws.location.model.ListDevicePositionsRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      ListDevicePositionsRequest,
      ListDevicePositionsResponse
    ]("listDevicePositions", api.listDevicePositions)(request.buildAwsValue())
      .map(zio.aws.location.model.ListDevicePositionsResponse.wrap)
      .provideEnvironment(r)
    def updateTracker(
        request: zio.aws.location.model.UpdateTrackerRequest
    ): IO[AwsError, zio.aws.location.model.UpdateTrackerResponse.ReadOnly] =
      asyncRequestResponse[UpdateTrackerRequest, UpdateTrackerResponse](
        "updateTracker",
        api.updateTracker
      )(request.buildAwsValue())
        .map(zio.aws.location.model.UpdateTrackerResponse.wrap)
        .provideEnvironment(r)
    def getDevicePosition(
        request: zio.aws.location.model.GetDevicePositionRequest
    ): IO[AwsError, zio.aws.location.model.GetDevicePositionResponse.ReadOnly] =
      asyncRequestResponse[GetDevicePositionRequest, GetDevicePositionResponse](
        "getDevicePosition",
        api.getDevicePosition
      )(request.buildAwsValue())
        .map(zio.aws.location.model.GetDevicePositionResponse.wrap)
        .provideEnvironment(r)
    def listGeofences(
        request: zio.aws.location.model.ListGeofencesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.location.model.ListGeofenceResponseEntry.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListGeofencesRequest,
      ListGeofencesResponse,
      ListGeofenceResponseEntry
    ](
      "listGeofences",
      api.listGeofences,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.entries().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.location.model.ListGeofenceResponseEntry.wrap(item))
      .provideEnvironment(r)
    def listGeofencesPaginated(
        request: zio.aws.location.model.ListGeofencesRequest
    ): IO[AwsError, zio.aws.location.model.ListGeofencesResponse.ReadOnly] =
      asyncRequestResponse[ListGeofencesRequest, ListGeofencesResponse](
        "listGeofences",
        api.listGeofences
      )(request.buildAwsValue())
        .map(zio.aws.location.model.ListGeofencesResponse.wrap)
        .provideEnvironment(r)
    def batchDeleteGeofence(
        request: zio.aws.location.model.BatchDeleteGeofenceRequest
    ): IO[
      AwsError,
      zio.aws.location.model.BatchDeleteGeofenceResponse.ReadOnly
    ] = asyncRequestResponse[
      BatchDeleteGeofenceRequest,
      BatchDeleteGeofenceResponse
    ]("batchDeleteGeofence", api.batchDeleteGeofence)(request.buildAwsValue())
      .map(zio.aws.location.model.BatchDeleteGeofenceResponse.wrap)
      .provideEnvironment(r)
    def batchPutGeofence(
        request: zio.aws.location.model.BatchPutGeofenceRequest
    ): IO[AwsError, zio.aws.location.model.BatchPutGeofenceResponse.ReadOnly] =
      asyncRequestResponse[BatchPutGeofenceRequest, BatchPutGeofenceResponse](
        "batchPutGeofence",
        api.batchPutGeofence
      )(request.buildAwsValue())
        .map(zio.aws.location.model.BatchPutGeofenceResponse.wrap)
        .provideEnvironment(r)
  }
  def listMaps(request: zio.aws.location.model.ListMapsRequest): ZStream[
    zio.aws.location.Location,
    AwsError,
    zio.aws.location.model.ListMapsResponseEntry.ReadOnly
  ] = ZStream.serviceWithStream(_.listMaps(request))
  def listMapsPaginated(request: zio.aws.location.model.ListMapsRequest): ZIO[
    zio.aws.location.Location,
    AwsError,
    zio.aws.location.model.ListMapsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listMapsPaginated(request))
  def getMapTile(request: zio.aws.location.model.GetMapTileRequest): ZIO[
    zio.aws.location.Location,
    AwsError,
    zio.aws.location.model.GetMapTileResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getMapTile(request))
  def describeTracker(
      request: zio.aws.location.model.DescribeTrackerRequest
  ): ZIO[
    zio.aws.location.Location,
    AwsError,
    zio.aws.location.model.DescribeTrackerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeTracker(request))
  def deleteMap(request: zio.aws.location.model.DeleteMapRequest): ZIO[
    zio.aws.location.Location,
    AwsError,
    zio.aws.location.model.DeleteMapResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteMap(request))
  def updateGeofenceCollection(
      request: zio.aws.location.model.UpdateGeofenceCollectionRequest
  ): ZIO[
    zio.aws.location.Location,
    AwsError,
    zio.aws.location.model.UpdateGeofenceCollectionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateGeofenceCollection(request))
  def deleteTracker(request: zio.aws.location.model.DeleteTrackerRequest): ZIO[
    zio.aws.location.Location,
    AwsError,
    zio.aws.location.model.DeleteTrackerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteTracker(request))
  def listPlaceIndexes(
      request: zio.aws.location.model.ListPlaceIndexesRequest
  ): ZStream[
    zio.aws.location.Location,
    AwsError,
    zio.aws.location.model.ListPlaceIndexesResponseEntry.ReadOnly
  ] = ZStream.serviceWithStream(_.listPlaceIndexes(request))
  def listPlaceIndexesPaginated(
      request: zio.aws.location.model.ListPlaceIndexesRequest
  ): ZIO[
    zio.aws.location.Location,
    AwsError,
    zio.aws.location.model.ListPlaceIndexesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listPlaceIndexesPaginated(request))
  def getMapGlyphs(request: zio.aws.location.model.GetMapGlyphsRequest): ZIO[
    zio.aws.location.Location,
    AwsError,
    zio.aws.location.model.GetMapGlyphsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getMapGlyphs(request))
  def batchEvaluateGeofences(
      request: zio.aws.location.model.BatchEvaluateGeofencesRequest
  ): ZIO[
    zio.aws.location.Location,
    AwsError,
    zio.aws.location.model.BatchEvaluateGeofencesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchEvaluateGeofences(request))
  def deletePlaceIndex(
      request: zio.aws.location.model.DeletePlaceIndexRequest
  ): ZIO[
    zio.aws.location.Location,
    AwsError,
    zio.aws.location.model.DeletePlaceIndexResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deletePlaceIndex(request))
  def describeRouteCalculator(
      request: zio.aws.location.model.DescribeRouteCalculatorRequest
  ): ZIO[
    zio.aws.location.Location,
    AwsError,
    zio.aws.location.model.DescribeRouteCalculatorResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeRouteCalculator(request))
  def calculateRouteMatrix(
      request: zio.aws.location.model.CalculateRouteMatrixRequest
  ): ZIO[
    zio.aws.location.Location,
    AwsError,
    zio.aws.location.model.CalculateRouteMatrixResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.calculateRouteMatrix(request))
  def putGeofence(request: zio.aws.location.model.PutGeofenceRequest): ZIO[
    zio.aws.location.Location,
    AwsError,
    zio.aws.location.model.PutGeofenceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putGeofence(request))
  def deleteGeofenceCollection(
      request: zio.aws.location.model.DeleteGeofenceCollectionRequest
  ): ZIO[
    zio.aws.location.Location,
    AwsError,
    zio.aws.location.model.DeleteGeofenceCollectionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteGeofenceCollection(request))
  def searchPlaceIndexForText(
      request: zio.aws.location.model.SearchPlaceIndexForTextRequest
  ): ZIO[
    zio.aws.location.Location,
    AwsError,
    zio.aws.location.model.SearchPlaceIndexForTextResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.searchPlaceIndexForText(request))
  def createRouteCalculator(
      request: zio.aws.location.model.CreateRouteCalculatorRequest
  ): ZIO[
    zio.aws.location.Location,
    AwsError,
    zio.aws.location.model.CreateRouteCalculatorResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createRouteCalculator(request))
  def searchPlaceIndexForPosition(
      request: zio.aws.location.model.SearchPlaceIndexForPositionRequest
  ): ZIO[
    zio.aws.location.Location,
    AwsError,
    zio.aws.location.model.SearchPlaceIndexForPositionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.searchPlaceIndexForPosition(request))
  def associateTrackerConsumer(
      request: zio.aws.location.model.AssociateTrackerConsumerRequest
  ): ZIO[
    zio.aws.location.Location,
    AwsError,
    zio.aws.location.model.AssociateTrackerConsumerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.associateTrackerConsumer(request))
  def batchDeleteDevicePositionHistory(
      request: zio.aws.location.model.BatchDeleteDevicePositionHistoryRequest
  ): ZIO[
    zio.aws.location.Location,
    AwsError,
    zio.aws.location.model.BatchDeleteDevicePositionHistoryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchDeleteDevicePositionHistory(request))
  def calculateRoute(
      request: zio.aws.location.model.CalculateRouteRequest
  ): ZIO[
    zio.aws.location.Location,
    AwsError,
    zio.aws.location.model.CalculateRouteResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.calculateRoute(request))
  def createGeofenceCollection(
      request: zio.aws.location.model.CreateGeofenceCollectionRequest
  ): ZIO[
    zio.aws.location.Location,
    AwsError,
    zio.aws.location.model.CreateGeofenceCollectionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createGeofenceCollection(request))
  def getGeofence(request: zio.aws.location.model.GetGeofenceRequest): ZIO[
    zio.aws.location.Location,
    AwsError,
    zio.aws.location.model.GetGeofenceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getGeofence(request))
  def describeGeofenceCollection(
      request: zio.aws.location.model.DescribeGeofenceCollectionRequest
  ): ZIO[
    zio.aws.location.Location,
    AwsError,
    zio.aws.location.model.DescribeGeofenceCollectionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeGeofenceCollection(request))
  def searchPlaceIndexForSuggestions(
      request: zio.aws.location.model.SearchPlaceIndexForSuggestionsRequest
  ): ZIO[
    zio.aws.location.Location,
    AwsError,
    zio.aws.location.model.SearchPlaceIndexForSuggestionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.searchPlaceIndexForSuggestions(request))
  def updateMap(request: zio.aws.location.model.UpdateMapRequest): ZIO[
    zio.aws.location.Location,
    AwsError,
    zio.aws.location.model.UpdateMapResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateMap(request))
  def deleteRouteCalculator(
      request: zio.aws.location.model.DeleteRouteCalculatorRequest
  ): ZIO[
    zio.aws.location.Location,
    AwsError,
    zio.aws.location.model.DeleteRouteCalculatorResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteRouteCalculator(request))
  def getMapStyleDescriptor(
      request: zio.aws.location.model.GetMapStyleDescriptorRequest
  ): ZIO[
    zio.aws.location.Location,
    AwsError,
    zio.aws.location.model.GetMapStyleDescriptorResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getMapStyleDescriptor(request))
  def untagResource(request: zio.aws.location.model.UntagResourceRequest): ZIO[
    zio.aws.location.Location,
    AwsError,
    zio.aws.location.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def disassociateTrackerConsumer(
      request: zio.aws.location.model.DisassociateTrackerConsumerRequest
  ): ZIO[
    zio.aws.location.Location,
    AwsError,
    zio.aws.location.model.DisassociateTrackerConsumerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disassociateTrackerConsumer(request))
  def getDevicePositionHistory(
      request: zio.aws.location.model.GetDevicePositionHistoryRequest
  ): ZStream[
    zio.aws.location.Location,
    AwsError,
    zio.aws.location.model.DevicePosition.ReadOnly
  ] = ZStream.serviceWithStream(_.getDevicePositionHistory(request))
  def getDevicePositionHistoryPaginated(
      request: zio.aws.location.model.GetDevicePositionHistoryRequest
  ): ZIO[
    zio.aws.location.Location,
    AwsError,
    zio.aws.location.model.GetDevicePositionHistoryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDevicePositionHistoryPaginated(request))
  def batchGetDevicePosition(
      request: zio.aws.location.model.BatchGetDevicePositionRequest
  ): ZIO[
    zio.aws.location.Location,
    AwsError,
    zio.aws.location.model.BatchGetDevicePositionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchGetDevicePosition(request))
  def listGeofenceCollections(
      request: zio.aws.location.model.ListGeofenceCollectionsRequest
  ): ZStream[
    zio.aws.location.Location,
    AwsError,
    zio.aws.location.model.ListGeofenceCollectionsResponseEntry.ReadOnly
  ] = ZStream.serviceWithStream(_.listGeofenceCollections(request))
  def listGeofenceCollectionsPaginated(
      request: zio.aws.location.model.ListGeofenceCollectionsRequest
  ): ZIO[
    zio.aws.location.Location,
    AwsError,
    zio.aws.location.model.ListGeofenceCollectionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listGeofenceCollectionsPaginated(request))
  def describePlaceIndex(
      request: zio.aws.location.model.DescribePlaceIndexRequest
  ): ZIO[
    zio.aws.location.Location,
    AwsError,
    zio.aws.location.model.DescribePlaceIndexResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describePlaceIndex(request))
  def updatePlaceIndex(
      request: zio.aws.location.model.UpdatePlaceIndexRequest
  ): ZIO[
    zio.aws.location.Location,
    AwsError,
    zio.aws.location.model.UpdatePlaceIndexResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updatePlaceIndex(request))
  def getMapSprites(request: zio.aws.location.model.GetMapSpritesRequest): ZIO[
    zio.aws.location.Location,
    AwsError,
    zio.aws.location.model.GetMapSpritesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getMapSprites(request))
  def listRouteCalculators(
      request: zio.aws.location.model.ListRouteCalculatorsRequest
  ): ZStream[
    zio.aws.location.Location,
    AwsError,
    zio.aws.location.model.ListRouteCalculatorsResponseEntry.ReadOnly
  ] = ZStream.serviceWithStream(_.listRouteCalculators(request))
  def listRouteCalculatorsPaginated(
      request: zio.aws.location.model.ListRouteCalculatorsRequest
  ): ZIO[
    zio.aws.location.Location,
    AwsError,
    zio.aws.location.model.ListRouteCalculatorsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listRouteCalculatorsPaginated(request))
  def batchUpdateDevicePosition(
      request: zio.aws.location.model.BatchUpdateDevicePositionRequest
  ): ZIO[
    zio.aws.location.Location,
    AwsError,
    zio.aws.location.model.BatchUpdateDevicePositionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchUpdateDevicePosition(request))
  def listTagsForResource(
      request: zio.aws.location.model.ListTagsForResourceRequest
  ): ZIO[
    zio.aws.location.Location,
    AwsError,
    zio.aws.location.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def listTrackerConsumers(
      request: zio.aws.location.model.ListTrackerConsumersRequest
  ): ZStream[zio.aws.location.Location, AwsError, Arn] =
    ZStream.serviceWithStream(_.listTrackerConsumers(request))
  def listTrackerConsumersPaginated(
      request: zio.aws.location.model.ListTrackerConsumersRequest
  ): ZIO[
    zio.aws.location.Location,
    AwsError,
    zio.aws.location.model.ListTrackerConsumersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTrackerConsumersPaginated(request))
  def createPlaceIndex(
      request: zio.aws.location.model.CreatePlaceIndexRequest
  ): ZIO[
    zio.aws.location.Location,
    AwsError,
    zio.aws.location.model.CreatePlaceIndexResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createPlaceIndex(request))
  def updateRouteCalculator(
      request: zio.aws.location.model.UpdateRouteCalculatorRequest
  ): ZIO[
    zio.aws.location.Location,
    AwsError,
    zio.aws.location.model.UpdateRouteCalculatorResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateRouteCalculator(request))
  def describeMap(request: zio.aws.location.model.DescribeMapRequest): ZIO[
    zio.aws.location.Location,
    AwsError,
    zio.aws.location.model.DescribeMapResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeMap(request))
  def tagResource(request: zio.aws.location.model.TagResourceRequest): ZIO[
    zio.aws.location.Location,
    AwsError,
    zio.aws.location.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def createTracker(request: zio.aws.location.model.CreateTrackerRequest): ZIO[
    zio.aws.location.Location,
    AwsError,
    zio.aws.location.model.CreateTrackerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createTracker(request))
  def createMap(request: zio.aws.location.model.CreateMapRequest): ZIO[
    zio.aws.location.Location,
    AwsError,
    zio.aws.location.model.CreateMapResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createMap(request))
  def listTrackers(
      request: zio.aws.location.model.ListTrackersRequest
  ): ZStream[
    zio.aws.location.Location,
    AwsError,
    zio.aws.location.model.ListTrackersResponseEntry.ReadOnly
  ] = ZStream.serviceWithStream(_.listTrackers(request))
  def listTrackersPaginated(
      request: zio.aws.location.model.ListTrackersRequest
  ): ZIO[
    zio.aws.location.Location,
    AwsError,
    zio.aws.location.model.ListTrackersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTrackersPaginated(request))
  def listDevicePositions(
      request: zio.aws.location.model.ListDevicePositionsRequest
  ): ZStream[
    zio.aws.location.Location,
    AwsError,
    zio.aws.location.model.ListDevicePositionsResponseEntry.ReadOnly
  ] = ZStream.serviceWithStream(_.listDevicePositions(request))
  def listDevicePositionsPaginated(
      request: zio.aws.location.model.ListDevicePositionsRequest
  ): ZIO[zio.aws.location.Location, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.listDevicePositionsPaginated(request))
  def updateTracker(request: zio.aws.location.model.UpdateTrackerRequest): ZIO[
    zio.aws.location.Location,
    AwsError,
    zio.aws.location.model.UpdateTrackerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateTracker(request))
  def getDevicePosition(
      request: zio.aws.location.model.GetDevicePositionRequest
  ): ZIO[
    zio.aws.location.Location,
    AwsError,
    zio.aws.location.model.GetDevicePositionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDevicePosition(request))
  def listGeofences(
      request: zio.aws.location.model.ListGeofencesRequest
  ): ZStream[
    zio.aws.location.Location,
    AwsError,
    zio.aws.location.model.ListGeofenceResponseEntry.ReadOnly
  ] = ZStream.serviceWithStream(_.listGeofences(request))
  def listGeofencesPaginated(
      request: zio.aws.location.model.ListGeofencesRequest
  ): ZIO[
    zio.aws.location.Location,
    AwsError,
    zio.aws.location.model.ListGeofencesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listGeofencesPaginated(request))
  def batchDeleteGeofence(
      request: zio.aws.location.model.BatchDeleteGeofenceRequest
  ): ZIO[
    zio.aws.location.Location,
    AwsError,
    zio.aws.location.model.BatchDeleteGeofenceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchDeleteGeofence(request))
  def batchPutGeofence(
      request: zio.aws.location.model.BatchPutGeofenceRequest
  ): ZIO[
    zio.aws.location.Location,
    AwsError,
    zio.aws.location.model.BatchPutGeofenceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchPutGeofence(request))
}
