package zio.aws.location.model
import scala.jdk.CollectionConverters._
sealed trait BatchItemErrorCode {
  def unwrap: software.amazon.awssdk.services.location.model.BatchItemErrorCode
}
object BatchItemErrorCode {
  def wrap(
      value: software.amazon.awssdk.services.location.model.BatchItemErrorCode
  ): zio.aws.location.model.BatchItemErrorCode = value match {
    case software.amazon.awssdk.services.location.model.BatchItemErrorCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.location.model.BatchItemErrorCode.ACCESS_DENIED_ERROR =>
      val r = AccessDeniedError
      r
    case software.amazon.awssdk.services.location.model.BatchItemErrorCode.CONFLICT_ERROR =>
      val r = ConflictError
      r
    case software.amazon.awssdk.services.location.model.BatchItemErrorCode.INTERNAL_SERVER_ERROR =>
      val r = InternalServerError
      r
    case software.amazon.awssdk.services.location.model.BatchItemErrorCode.RESOURCE_NOT_FOUND_ERROR =>
      val r = ResourceNotFoundError
      r
    case software.amazon.awssdk.services.location.model.BatchItemErrorCode.THROTTLING_ERROR =>
      val r = ThrottlingError
      r
    case software.amazon.awssdk.services.location.model.BatchItemErrorCode.VALIDATION_ERROR =>
      val r = ValidationError
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.location.model.BatchItemErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.location.model.BatchItemErrorCode =
      software.amazon.awssdk.services.location.model.BatchItemErrorCode.UNKNOWN_TO_SDK_VERSION
  }
  case object AccessDeniedError
      extends zio.aws.location.model.BatchItemErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.location.model.BatchItemErrorCode =
      software.amazon.awssdk.services.location.model.BatchItemErrorCode.ACCESS_DENIED_ERROR
  }
  case object ConflictError extends zio.aws.location.model.BatchItemErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.location.model.BatchItemErrorCode =
      software.amazon.awssdk.services.location.model.BatchItemErrorCode.CONFLICT_ERROR
  }
  case object InternalServerError
      extends zio.aws.location.model.BatchItemErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.location.model.BatchItemErrorCode =
      software.amazon.awssdk.services.location.model.BatchItemErrorCode.INTERNAL_SERVER_ERROR
  }
  case object ResourceNotFoundError
      extends zio.aws.location.model.BatchItemErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.location.model.BatchItemErrorCode =
      software.amazon.awssdk.services.location.model.BatchItemErrorCode.RESOURCE_NOT_FOUND_ERROR
  }
  case object ThrottlingError
      extends zio.aws.location.model.BatchItemErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.location.model.BatchItemErrorCode =
      software.amazon.awssdk.services.location.model.BatchItemErrorCode.THROTTLING_ERROR
  }
  case object ValidationError
      extends zio.aws.location.model.BatchItemErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.location.model.BatchItemErrorCode =
      software.amazon.awssdk.services.location.model.BatchItemErrorCode.VALIDATION_ERROR
  }
}
