package zio.aws.location.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.location.model.primitives.ResourceName
import scala.jdk.CollectionConverters._
final case class BatchPutGeofenceRequest(
    collectionName: ResourceName,
    entries: Iterable[zio.aws.location.model.BatchPutGeofenceRequestEntry]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.BatchPutGeofenceRequest = {
    import BatchPutGeofenceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.BatchPutGeofenceRequest
      .builder()
      .collectionName(ResourceName.unwrap(collectionName): java.lang.String)
      .entries(entries.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.location.model.BatchPutGeofenceRequest.ReadOnly =
    zio.aws.location.model.BatchPutGeofenceRequest.wrap(buildAwsValue())
}
object BatchPutGeofenceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.BatchPutGeofenceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.BatchPutGeofenceRequest =
      zio.aws.location.model.BatchPutGeofenceRequest(
        collectionName,
        entries.map { item =>
          item.asEditable
        }
      )
    def collectionName: ResourceName
    def entries
        : List[zio.aws.location.model.BatchPutGeofenceRequestEntry.ReadOnly]
    def getCollectionName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(collectionName)
    def getEntries: ZIO[Any, Nothing, List[
      zio.aws.location.model.BatchPutGeofenceRequestEntry.ReadOnly
    ]] = ZIO.succeed(entries)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.BatchPutGeofenceRequest
  ) extends zio.aws.location.model.BatchPutGeofenceRequest.ReadOnly {
    override val collectionName: ResourceName =
      zio.aws.location.model.primitives.ResourceName(impl.collectionName())
    override val entries
        : List[zio.aws.location.model.BatchPutGeofenceRequestEntry.ReadOnly] =
      impl
        .entries()
        .asScala
        .map { item =>
          zio.aws.location.model.BatchPutGeofenceRequestEntry.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.BatchPutGeofenceRequest
  ): zio.aws.location.model.BatchPutGeofenceRequest.ReadOnly = new Wrapper(impl)
}
