package zio.aws.location.model
import zio.aws.location.model.primitives.{Timestamp, ResourceName}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class CalculateRouteMatrixRequest(
    calculatorName: ResourceName,
    carModeOptions: Optional[
      zio.aws.location.model.CalculateRouteCarModeOptions
    ] = Optional.Absent,
    departNow: Optional[Boolean] = Optional.Absent,
    departurePositions: Iterable[Iterable[Double]],
    departureTime: Optional[Timestamp] = Optional.Absent,
    destinationPositions: Iterable[Iterable[Double]],
    distanceUnit: Optional[zio.aws.location.model.DistanceUnit] =
      Optional.Absent,
    travelMode: Optional[zio.aws.location.model.TravelMode] = Optional.Absent,
    truckModeOptions: Optional[
      zio.aws.location.model.CalculateRouteTruckModeOptions
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.CalculateRouteMatrixRequest = {
    import CalculateRouteMatrixRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.CalculateRouteMatrixRequest
      .builder()
      .calculatorName(ResourceName.unwrap(calculatorName): java.lang.String)
      .optionallyWith(carModeOptions.map(value => value.buildAwsValue()))(
        _.carModeOptions
      )
      .optionallyWith(departNow.map(value => value: java.lang.Boolean))(
        _.departNow
      )
      .departurePositions(departurePositions.map { item =>
        item.map { item =>
          item: java.lang.Double
        }.asJavaCollection
      }.asJavaCollection)
      .optionallyWith(
        departureTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.departureTime)
      .destinationPositions(destinationPositions.map { item =>
        item.map { item =>
          item: java.lang.Double
        }.asJavaCollection
      }.asJavaCollection)
      .optionallyWith(distanceUnit.map(value => value.unwrap))(_.distanceUnit)
      .optionallyWith(travelMode.map(value => value.unwrap))(_.travelMode)
      .optionallyWith(truckModeOptions.map(value => value.buildAwsValue()))(
        _.truckModeOptions
      )
      .build()
  }
  def asReadOnly: zio.aws.location.model.CalculateRouteMatrixRequest.ReadOnly =
    zio.aws.location.model.CalculateRouteMatrixRequest.wrap(buildAwsValue())
}
object CalculateRouteMatrixRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.CalculateRouteMatrixRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.CalculateRouteMatrixRequest =
      zio.aws.location.model.CalculateRouteMatrixRequest(
        calculatorName,
        carModeOptions.map(value => value.asEditable),
        departNow.map(value => value),
        departurePositions,
        departureTime.map(value => value),
        destinationPositions,
        distanceUnit.map(value => value),
        travelMode.map(value => value),
        truckModeOptions.map(value => value.asEditable)
      )
    def calculatorName: ResourceName
    def carModeOptions
        : Optional[zio.aws.location.model.CalculateRouteCarModeOptions.ReadOnly]
    def departNow: Optional[Boolean]
    def departurePositions: List[List[Double]]
    def departureTime: Optional[Timestamp]
    def destinationPositions: List[List[Double]]
    def distanceUnit: Optional[zio.aws.location.model.DistanceUnit]
    def travelMode: Optional[zio.aws.location.model.TravelMode]
    def truckModeOptions: Optional[
      zio.aws.location.model.CalculateRouteTruckModeOptions.ReadOnly
    ]
    def getCalculatorName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(calculatorName)
    def getCarModeOptions: ZIO[
      Any,
      AwsError,
      zio.aws.location.model.CalculateRouteCarModeOptions.ReadOnly
    ] = AwsError.unwrapOptionField("carModeOptions", carModeOptions)
    def getDepartNow: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("departNow", departNow)
    def getDeparturePositions: ZIO[Any, Nothing, List[List[Double]]] =
      ZIO.succeed(departurePositions)
    def getDepartureTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("departureTime", departureTime)
    def getDestinationPositions: ZIO[Any, Nothing, List[List[Double]]] =
      ZIO.succeed(destinationPositions)
    def getDistanceUnit
        : ZIO[Any, AwsError, zio.aws.location.model.DistanceUnit] =
      AwsError.unwrapOptionField("distanceUnit", distanceUnit)
    def getTravelMode: ZIO[Any, AwsError, zio.aws.location.model.TravelMode] =
      AwsError.unwrapOptionField("travelMode", travelMode)
    def getTruckModeOptions: ZIO[
      Any,
      AwsError,
      zio.aws.location.model.CalculateRouteTruckModeOptions.ReadOnly
    ] = AwsError.unwrapOptionField("truckModeOptions", truckModeOptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.CalculateRouteMatrixRequest
  ) extends zio.aws.location.model.CalculateRouteMatrixRequest.ReadOnly {
    override val calculatorName: ResourceName =
      zio.aws.location.model.primitives.ResourceName(impl.calculatorName())
    override val carModeOptions: Optional[
      zio.aws.location.model.CalculateRouteCarModeOptions.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.carModeOptions())
      .map(value =>
        zio.aws.location.model.CalculateRouteCarModeOptions.wrap(value)
      )
    override val departNow: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.departNow())
      .map(value => value: Boolean)
    override val departurePositions: List[List[Double]] = impl
      .departurePositions()
      .asScala
      .map { item =>
        item.asScala.map { item =>
          item: Double
        }.toList
      }
      .toList
    override val departureTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.departureTime())
      .map(value => zio.aws.location.model.primitives.Timestamp(value))
    override val destinationPositions: List[List[Double]] = impl
      .destinationPositions()
      .asScala
      .map { item =>
        item.asScala.map { item =>
          item: Double
        }.toList
      }
      .toList
    override val distanceUnit: Optional[zio.aws.location.model.DistanceUnit] =
      zio.aws.core.internal
        .optionalFromNullable(impl.distanceUnit())
        .map(value => zio.aws.location.model.DistanceUnit.wrap(value))
    override val travelMode: Optional[zio.aws.location.model.TravelMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.travelMode())
        .map(value => zio.aws.location.model.TravelMode.wrap(value))
    override val truckModeOptions: Optional[
      zio.aws.location.model.CalculateRouteTruckModeOptions.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.truckModeOptions())
      .map(value =>
        zio.aws.location.model.CalculateRouteTruckModeOptions.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.CalculateRouteMatrixRequest
  ): zio.aws.location.model.CalculateRouteMatrixRequest.ReadOnly = new Wrapper(
    impl
  )
}
