package zio.aws.location.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.location.model.primitives.{
  CalculateRouteMatrixSummaryRouteCountInteger,
  CalculateRouteMatrixSummaryErrorCountInteger
}
import scala.jdk.CollectionConverters._
final case class CalculateRouteMatrixSummary(
    dataSource: String,
    distanceUnit: zio.aws.location.model.DistanceUnit,
    errorCount: CalculateRouteMatrixSummaryErrorCountInteger,
    routeCount: CalculateRouteMatrixSummaryRouteCountInteger
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.CalculateRouteMatrixSummary = {
    import CalculateRouteMatrixSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.CalculateRouteMatrixSummary
      .builder()
      .dataSource(dataSource: java.lang.String)
      .distanceUnit(distanceUnit.unwrap)
      .errorCount(
        CalculateRouteMatrixSummaryErrorCountInteger.unwrap(errorCount): Integer
      )
      .routeCount(
        CalculateRouteMatrixSummaryRouteCountInteger.unwrap(routeCount): Integer
      )
      .build()
  }
  def asReadOnly: zio.aws.location.model.CalculateRouteMatrixSummary.ReadOnly =
    zio.aws.location.model.CalculateRouteMatrixSummary.wrap(buildAwsValue())
}
object CalculateRouteMatrixSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.CalculateRouteMatrixSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.CalculateRouteMatrixSummary =
      zio.aws.location.model.CalculateRouteMatrixSummary(
        dataSource,
        distanceUnit,
        errorCount,
        routeCount
      )
    def dataSource: String
    def distanceUnit: zio.aws.location.model.DistanceUnit
    def errorCount: CalculateRouteMatrixSummaryErrorCountInteger
    def routeCount: CalculateRouteMatrixSummaryRouteCountInteger
    def getDataSource: ZIO[Any, Nothing, String] = ZIO.succeed(dataSource)
    def getDistanceUnit
        : ZIO[Any, Nothing, zio.aws.location.model.DistanceUnit] =
      ZIO.succeed(distanceUnit)
    def getErrorCount
        : ZIO[Any, Nothing, CalculateRouteMatrixSummaryErrorCountInteger] =
      ZIO.succeed(errorCount)
    def getRouteCount
        : ZIO[Any, Nothing, CalculateRouteMatrixSummaryRouteCountInteger] =
      ZIO.succeed(routeCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.CalculateRouteMatrixSummary
  ) extends zio.aws.location.model.CalculateRouteMatrixSummary.ReadOnly {
    override val dataSource: String = impl.dataSource(): String
    override val distanceUnit: zio.aws.location.model.DistanceUnit =
      zio.aws.location.model.DistanceUnit.wrap(impl.distanceUnit())
    override val errorCount: CalculateRouteMatrixSummaryErrorCountInteger =
      zio.aws.location.model.primitives
        .CalculateRouteMatrixSummaryErrorCountInteger(impl.errorCount())
    override val routeCount: CalculateRouteMatrixSummaryRouteCountInteger =
      zio.aws.location.model.primitives
        .CalculateRouteMatrixSummaryRouteCountInteger(impl.routeCount())
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.CalculateRouteMatrixSummary
  ): zio.aws.location.model.CalculateRouteMatrixSummary.ReadOnly = new Wrapper(
    impl
  )
}
