package zio.aws.location.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.location.model.primitives.{
  CalculateRouteSummaryDurationSecondsDouble,
  CalculateRouteSummaryDistanceDouble
}
import scala.jdk.CollectionConverters._
final case class CalculateRouteSummary(
    dataSource: String,
    distance: CalculateRouteSummaryDistanceDouble,
    distanceUnit: zio.aws.location.model.DistanceUnit,
    durationSeconds: CalculateRouteSummaryDurationSecondsDouble,
    routeBBox: Iterable[Double]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.CalculateRouteSummary = {
    import CalculateRouteSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.CalculateRouteSummary
      .builder()
      .dataSource(dataSource: java.lang.String)
      .distance(
        CalculateRouteSummaryDistanceDouble.unwrap(distance): java.lang.Double
      )
      .distanceUnit(distanceUnit.unwrap)
      .durationSeconds(
        CalculateRouteSummaryDurationSecondsDouble.unwrap(
          durationSeconds
        ): java.lang.Double
      )
      .routeBBox(routeBBox.map { item =>
        item: java.lang.Double
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.location.model.CalculateRouteSummary.ReadOnly =
    zio.aws.location.model.CalculateRouteSummary.wrap(buildAwsValue())
}
object CalculateRouteSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.CalculateRouteSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.CalculateRouteSummary =
      zio.aws.location.model.CalculateRouteSummary(
        dataSource,
        distance,
        distanceUnit,
        durationSeconds,
        routeBBox
      )
    def dataSource: String
    def distance: CalculateRouteSummaryDistanceDouble
    def distanceUnit: zio.aws.location.model.DistanceUnit
    def durationSeconds: CalculateRouteSummaryDurationSecondsDouble
    def routeBBox: List[Double]
    def getDataSource: ZIO[Any, Nothing, String] = ZIO.succeed(dataSource)
    def getDistance: ZIO[Any, Nothing, CalculateRouteSummaryDistanceDouble] =
      ZIO.succeed(distance)
    def getDistanceUnit
        : ZIO[Any, Nothing, zio.aws.location.model.DistanceUnit] =
      ZIO.succeed(distanceUnit)
    def getDurationSeconds
        : ZIO[Any, Nothing, CalculateRouteSummaryDurationSecondsDouble] =
      ZIO.succeed(durationSeconds)
    def getRouteBBox: ZIO[Any, Nothing, List[Double]] = ZIO.succeed(routeBBox)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.CalculateRouteSummary
  ) extends zio.aws.location.model.CalculateRouteSummary.ReadOnly {
    override val dataSource: String = impl.dataSource(): String
    override val distance: CalculateRouteSummaryDistanceDouble =
      zio.aws.location.model.primitives
        .CalculateRouteSummaryDistanceDouble(impl.distance())
    override val distanceUnit: zio.aws.location.model.DistanceUnit =
      zio.aws.location.model.DistanceUnit.wrap(impl.distanceUnit())
    override val durationSeconds: CalculateRouteSummaryDurationSecondsDouble =
      zio.aws.location.model.primitives
        .CalculateRouteSummaryDurationSecondsDouble(impl.durationSeconds())
    override val routeBBox: List[Double] = impl
      .routeBBox()
      .asScala
      .map { item =>
        item: Double
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.CalculateRouteSummary
  ): zio.aws.location.model.CalculateRouteSummary.ReadOnly = new Wrapper(impl)
}
