package zio.aws.location.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import zio.aws.location.model.primitives.{Timestamp, ResourceName, Arn}
import scala.jdk.CollectionConverters._
final case class CreateGeofenceCollectionResponse(
    collectionArn: Arn,
    collectionName: ResourceName,
    createTime: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.CreateGeofenceCollectionResponse = {
    import CreateGeofenceCollectionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.CreateGeofenceCollectionResponse
      .builder()
      .collectionArn(Arn.unwrap(collectionArn): java.lang.String)
      .collectionName(ResourceName.unwrap(collectionName): java.lang.String)
      .createTime(Timestamp.unwrap(createTime): Instant)
      .build()
  }
  def asReadOnly
      : zio.aws.location.model.CreateGeofenceCollectionResponse.ReadOnly =
    zio.aws.location.model.CreateGeofenceCollectionResponse
      .wrap(buildAwsValue())
}
object CreateGeofenceCollectionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.CreateGeofenceCollectionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.CreateGeofenceCollectionResponse =
      zio.aws.location.model.CreateGeofenceCollectionResponse(
        collectionArn,
        collectionName,
        createTime
      )
    def collectionArn: Arn
    def collectionName: ResourceName
    def createTime: Timestamp
    def getCollectionArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(collectionArn)
    def getCollectionName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(collectionName)
    def getCreateTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.CreateGeofenceCollectionResponse
  ) extends zio.aws.location.model.CreateGeofenceCollectionResponse.ReadOnly {
    override val collectionArn: Arn =
      zio.aws.location.model.primitives.Arn(impl.collectionArn())
    override val collectionName: ResourceName =
      zio.aws.location.model.primitives.ResourceName(impl.collectionName())
    override val createTime: Timestamp =
      zio.aws.location.model.primitives.Timestamp(impl.createTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.CreateGeofenceCollectionResponse
  ): zio.aws.location.model.CreateGeofenceCollectionResponse.ReadOnly =
    new Wrapper(impl)
}
