package zio.aws.location.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import zio.aws.location.model.primitives.{ResourceName, Arn, Timestamp}
import scala.jdk.CollectionConverters._
final case class CreateTrackerResponse(
    createTime: Timestamp,
    trackerArn: Arn,
    trackerName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.CreateTrackerResponse = {
    import CreateTrackerResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.CreateTrackerResponse
      .builder()
      .createTime(Timestamp.unwrap(createTime): Instant)
      .trackerArn(Arn.unwrap(trackerArn): java.lang.String)
      .trackerName(ResourceName.unwrap(trackerName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.location.model.CreateTrackerResponse.ReadOnly =
    zio.aws.location.model.CreateTrackerResponse.wrap(buildAwsValue())
}
object CreateTrackerResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.CreateTrackerResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.CreateTrackerResponse =
      zio.aws.location.model
        .CreateTrackerResponse(createTime, trackerArn, trackerName)
    def createTime: Timestamp
    def trackerArn: Arn
    def trackerName: ResourceName
    def getCreateTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createTime)
    def getTrackerArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(trackerArn)
    def getTrackerName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(trackerName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.CreateTrackerResponse
  ) extends zio.aws.location.model.CreateTrackerResponse.ReadOnly {
    override val createTime: Timestamp =
      zio.aws.location.model.primitives.Timestamp(impl.createTime())
    override val trackerArn: Arn =
      zio.aws.location.model.primitives.Arn(impl.trackerArn())
    override val trackerName: ResourceName =
      zio.aws.location.model.primitives.ResourceName(impl.trackerName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.CreateTrackerResponse
  ): zio.aws.location.model.CreateTrackerResponse.ReadOnly = new Wrapper(impl)
}
