package zio.aws.location.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.location.model.primitives.ResourceName
import scala.jdk.CollectionConverters._
final case class DeleteRouteCalculatorRequest(calculatorName: ResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.DeleteRouteCalculatorRequest = {
    import DeleteRouteCalculatorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.DeleteRouteCalculatorRequest
      .builder()
      .calculatorName(ResourceName.unwrap(calculatorName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.location.model.DeleteRouteCalculatorRequest.ReadOnly =
    zio.aws.location.model.DeleteRouteCalculatorRequest.wrap(buildAwsValue())
}
object DeleteRouteCalculatorRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.DeleteRouteCalculatorRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.DeleteRouteCalculatorRequest =
      zio.aws.location.model.DeleteRouteCalculatorRequest(calculatorName)
    def calculatorName: ResourceName
    def getCalculatorName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(calculatorName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.DeleteRouteCalculatorRequest
  ) extends zio.aws.location.model.DeleteRouteCalculatorRequest.ReadOnly {
    override val calculatorName: ResourceName =
      zio.aws.location.model.primitives.ResourceName(impl.calculatorName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.DeleteRouteCalculatorRequest
  ): zio.aws.location.model.DeleteRouteCalculatorRequest.ReadOnly = new Wrapper(
    impl
  )
}
