package zio.aws.location.model
import scala.jdk.CollectionConverters._
sealed trait IntendedUse {
  def unwrap: software.amazon.awssdk.services.location.model.IntendedUse
}
object IntendedUse {
  def wrap(
      value: software.amazon.awssdk.services.location.model.IntendedUse
  ): zio.aws.location.model.IntendedUse = value match {
    case software.amazon.awssdk.services.location.model.IntendedUse.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.location.model.IntendedUse.SINGLE_USE =>
      val r = SingleUse
      r
    case software.amazon.awssdk.services.location.model.IntendedUse.STORAGE =>
      val r = Storage
      r
  }
  case object unknownToSdkVersion extends zio.aws.location.model.IntendedUse {
    override def unwrap
        : software.amazon.awssdk.services.location.model.IntendedUse =
      software.amazon.awssdk.services.location.model.IntendedUse.UNKNOWN_TO_SDK_VERSION
  }
  case object SingleUse extends zio.aws.location.model.IntendedUse {
    override def unwrap
        : software.amazon.awssdk.services.location.model.IntendedUse =
      software.amazon.awssdk.services.location.model.IntendedUse.SINGLE_USE
  }
  case object Storage extends zio.aws.location.model.IntendedUse {
    override def unwrap
        : software.amazon.awssdk.services.location.model.IntendedUse =
      software.amazon.awssdk.services.location.model.IntendedUse.STORAGE
  }
}
