package zio.aws.location.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.location.model.primitives.MapStyle
import scala.jdk.CollectionConverters._
final case class MapConfiguration(style: MapStyle) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.MapConfiguration = {
    import MapConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.MapConfiguration
      .builder()
      .style(MapStyle.unwrap(style): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.location.model.MapConfiguration.ReadOnly =
    zio.aws.location.model.MapConfiguration.wrap(buildAwsValue())
}
object MapConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.MapConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.MapConfiguration =
      zio.aws.location.model.MapConfiguration(style)
    def style: MapStyle
    def getStyle: ZIO[Any, Nothing, MapStyle] = ZIO.succeed(style)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.MapConfiguration
  ) extends zio.aws.location.model.MapConfiguration.ReadOnly {
    override val style: MapStyle =
      zio.aws.location.model.primitives.MapStyle(impl.style())
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.MapConfiguration
  ): zio.aws.location.model.MapConfiguration.ReadOnly = new Wrapper(impl)
}
