package zio.aws.location.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RouteMatrixEntryError(
    code: zio.aws.location.model.RouteMatrixErrorCode,
    message: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.RouteMatrixEntryError = {
    import RouteMatrixEntryError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.RouteMatrixEntryError
      .builder()
      .code(code.unwrap)
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .build()
  }
  def asReadOnly: zio.aws.location.model.RouteMatrixEntryError.ReadOnly =
    zio.aws.location.model.RouteMatrixEntryError.wrap(buildAwsValue())
}
object RouteMatrixEntryError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.RouteMatrixEntryError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.RouteMatrixEntryError =
      zio.aws.location.model
        .RouteMatrixEntryError(code, message.map(value => value))
    def code: zio.aws.location.model.RouteMatrixErrorCode
    def message: Optional[String]
    def getCode
        : ZIO[Any, Nothing, zio.aws.location.model.RouteMatrixErrorCode] =
      ZIO.succeed(code)
    def getMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.RouteMatrixEntryError
  ) extends zio.aws.location.model.RouteMatrixEntryError.ReadOnly {
    override val code: zio.aws.location.model.RouteMatrixErrorCode =
      zio.aws.location.model.RouteMatrixErrorCode.wrap(impl.code())
    override val message: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.RouteMatrixEntryError
  ): zio.aws.location.model.RouteMatrixEntryError.ReadOnly = new Wrapper(impl)
}
