package zio.aws.location.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.location.model.primitives.SearchForPositionResultDistanceDouble
import scala.jdk.CollectionConverters._
final case class SearchForPositionResult(
    distance: SearchForPositionResultDistanceDouble,
    place: zio.aws.location.model.Place
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.SearchForPositionResult = {
    import SearchForPositionResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.SearchForPositionResult
      .builder()
      .distance(
        SearchForPositionResultDistanceDouble.unwrap(distance): java.lang.Double
      )
      .place(place.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.location.model.SearchForPositionResult.ReadOnly =
    zio.aws.location.model.SearchForPositionResult.wrap(buildAwsValue())
}
object SearchForPositionResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.SearchForPositionResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.SearchForPositionResult =
      zio.aws.location.model.SearchForPositionResult(distance, place.asEditable)
    def distance: SearchForPositionResultDistanceDouble
    def place: zio.aws.location.model.Place.ReadOnly
    def getDistance: ZIO[Any, Nothing, SearchForPositionResultDistanceDouble] =
      ZIO.succeed(distance)
    def getPlace: ZIO[Any, Nothing, zio.aws.location.model.Place.ReadOnly] =
      ZIO.succeed(place)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.SearchForPositionResult
  ) extends zio.aws.location.model.SearchForPositionResult.ReadOnly {
    override val distance: SearchForPositionResultDistanceDouble =
      zio.aws.location.model.primitives
        .SearchForPositionResultDistanceDouble(impl.distance())
    override val place: zio.aws.location.model.Place.ReadOnly =
      zio.aws.location.model.Place.wrap(impl.place())
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.SearchForPositionResult
  ): zio.aws.location.model.SearchForPositionResult.ReadOnly = new Wrapper(impl)
}
