package zio.aws.location.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class SearchPlaceIndexForPositionResponse(
    results: Iterable[zio.aws.location.model.SearchForPositionResult],
    summary: zio.aws.location.model.SearchPlaceIndexForPositionSummary
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.SearchPlaceIndexForPositionResponse = {
    import SearchPlaceIndexForPositionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.SearchPlaceIndexForPositionResponse
      .builder()
      .results(results.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .summary(summary.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.location.model.SearchPlaceIndexForPositionResponse.ReadOnly =
    zio.aws.location.model.SearchPlaceIndexForPositionResponse
      .wrap(buildAwsValue())
}
object SearchPlaceIndexForPositionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.SearchPlaceIndexForPositionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.SearchPlaceIndexForPositionResponse =
      zio.aws.location.model.SearchPlaceIndexForPositionResponse(
        results.map { item =>
          item.asEditable
        },
        summary.asEditable
      )
    def results: List[zio.aws.location.model.SearchForPositionResult.ReadOnly]
    def summary
        : zio.aws.location.model.SearchPlaceIndexForPositionSummary.ReadOnly
    def getResults: ZIO[Any, Nothing, List[
      zio.aws.location.model.SearchForPositionResult.ReadOnly
    ]] = ZIO.succeed(results)
    def getSummary: ZIO[
      Any,
      Nothing,
      zio.aws.location.model.SearchPlaceIndexForPositionSummary.ReadOnly
    ] = ZIO.succeed(summary)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.SearchPlaceIndexForPositionResponse
  ) extends zio.aws.location.model.SearchPlaceIndexForPositionResponse.ReadOnly {
    override val results
        : List[zio.aws.location.model.SearchForPositionResult.ReadOnly] = impl
      .results()
      .asScala
      .map { item =>
        zio.aws.location.model.SearchForPositionResult.wrap(item)
      }
      .toList
    override val summary
        : zio.aws.location.model.SearchPlaceIndexForPositionSummary.ReadOnly =
      zio.aws.location.model.SearchPlaceIndexForPositionSummary
        .wrap(impl.summary())
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.SearchPlaceIndexForPositionResponse
  ): zio.aws.location.model.SearchPlaceIndexForPositionResponse.ReadOnly =
    new Wrapper(impl)
}
