package zio.aws.location.model
import zio.aws.location.model.primitives.{
  SyntheticSearchPlaceIndexForSuggestionsRequestString,
  LanguageTag,
  SearchPlaceIndexForSuggestionsRequestMaxResultsInteger,
  CountryCode,
  ResourceName
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class SearchPlaceIndexForSuggestionsRequest(
    biasPosition: Optional[Iterable[Double]] = Optional.Absent,
    filterBBox: Optional[Iterable[Double]] = Optional.Absent,
    filterCountries: Optional[Iterable[CountryCode]] = Optional.Absent,
    indexName: ResourceName,
    language: Optional[LanguageTag] = Optional.Absent,
    maxResults: Optional[
      SearchPlaceIndexForSuggestionsRequestMaxResultsInteger
    ] = Optional.Absent,
    text: SyntheticSearchPlaceIndexForSuggestionsRequestString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.SearchPlaceIndexForSuggestionsRequest = {
    import SearchPlaceIndexForSuggestionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.SearchPlaceIndexForSuggestionsRequest
      .builder()
      .optionallyWith(
        biasPosition.map(value =>
          value.map { item =>
            item: java.lang.Double
          }.asJavaCollection
        )
      )(_.biasPosition)
      .optionallyWith(
        filterBBox.map(value =>
          value.map { item =>
            item: java.lang.Double
          }.asJavaCollection
        )
      )(_.filterBBox)
      .optionallyWith(
        filterCountries.map(value =>
          value.map { item =>
            CountryCode.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.filterCountries)
      .indexName(ResourceName.unwrap(indexName): java.lang.String)
      .optionallyWith(
        language.map(value => LanguageTag.unwrap(value): java.lang.String)
      )(_.language)
      .optionallyWith(
        maxResults.map(value =>
          SearchPlaceIndexForSuggestionsRequestMaxResultsInteger.unwrap(
            value
          ): Integer
        )
      )(_.maxResults)
      .text(
        SyntheticSearchPlaceIndexForSuggestionsRequestString.unwrap(
          text
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.location.model.SearchPlaceIndexForSuggestionsRequest.ReadOnly =
    zio.aws.location.model.SearchPlaceIndexForSuggestionsRequest
      .wrap(buildAwsValue())
}
object SearchPlaceIndexForSuggestionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.SearchPlaceIndexForSuggestionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.location.model.SearchPlaceIndexForSuggestionsRequest =
      zio.aws.location.model.SearchPlaceIndexForSuggestionsRequest(
        biasPosition.map(value => value),
        filterBBox.map(value => value),
        filterCountries.map(value => value),
        indexName,
        language.map(value => value),
        maxResults.map(value => value),
        text
      )
    def biasPosition: Optional[List[Double]]
    def filterBBox: Optional[List[Double]]
    def filterCountries: Optional[List[CountryCode]]
    def indexName: ResourceName
    def language: Optional[LanguageTag]
    def maxResults
        : Optional[SearchPlaceIndexForSuggestionsRequestMaxResultsInteger]
    def text: SyntheticSearchPlaceIndexForSuggestionsRequestString
    def getBiasPosition: ZIO[Any, AwsError, List[Double]] =
      AwsError.unwrapOptionField("biasPosition", biasPosition)
    def getFilterBBox: ZIO[Any, AwsError, List[Double]] =
      AwsError.unwrapOptionField("filterBBox", filterBBox)
    def getFilterCountries: ZIO[Any, AwsError, List[CountryCode]] =
      AwsError.unwrapOptionField("filterCountries", filterCountries)
    def getIndexName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(indexName)
    def getLanguage: ZIO[Any, AwsError, LanguageTag] =
      AwsError.unwrapOptionField("language", language)
    def getMaxResults: ZIO[
      Any,
      AwsError,
      SearchPlaceIndexForSuggestionsRequestMaxResultsInteger
    ] = AwsError.unwrapOptionField("maxResults", maxResults)
    def getText: ZIO[
      Any,
      Nothing,
      SyntheticSearchPlaceIndexForSuggestionsRequestString
    ] = ZIO.succeed(text)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.SearchPlaceIndexForSuggestionsRequest
  ) extends zio.aws.location.model.SearchPlaceIndexForSuggestionsRequest.ReadOnly {
    override val biasPosition: Optional[List[Double]] = zio.aws.core.internal
      .optionalFromNullable(impl.biasPosition())
      .map(value =>
        value.asScala.map { item =>
          item: Double
        }.toList
      )
    override val filterBBox: Optional[List[Double]] = zio.aws.core.internal
      .optionalFromNullable(impl.filterBBox())
      .map(value =>
        value.asScala.map { item =>
          item: Double
        }.toList
      )
    override val filterCountries: Optional[List[CountryCode]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filterCountries())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.location.model.primitives.CountryCode(item)
          }.toList
        )
    override val indexName: ResourceName =
      zio.aws.location.model.primitives.ResourceName(impl.indexName())
    override val language: Optional[LanguageTag] = zio.aws.core.internal
      .optionalFromNullable(impl.language())
      .map(value => zio.aws.location.model.primitives.LanguageTag(value))
    override val maxResults
        : Optional[SearchPlaceIndexForSuggestionsRequestMaxResultsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.location.model.primitives
            .SearchPlaceIndexForSuggestionsRequestMaxResultsInteger(value)
        )
    override val text: SyntheticSearchPlaceIndexForSuggestionsRequestString =
      zio.aws.location.model.primitives
        .SyntheticSearchPlaceIndexForSuggestionsRequestString(impl.text())
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.SearchPlaceIndexForSuggestionsRequest
  ): zio.aws.location.model.SearchPlaceIndexForSuggestionsRequest.ReadOnly =
    new Wrapper(impl)
}
