package zio.aws.location.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.location.model.primitives.{
  TruckDimensionsWidthDouble,
  TruckDimensionsLengthDouble,
  TruckDimensionsHeightDouble
}
import scala.jdk.CollectionConverters._
final case class TruckDimensions(
    height: Optional[TruckDimensionsHeightDouble] = Optional.Absent,
    length: Optional[TruckDimensionsLengthDouble] = Optional.Absent,
    unit: Optional[zio.aws.location.model.DimensionUnit] = Optional.Absent,
    width: Optional[TruckDimensionsWidthDouble] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.TruckDimensions = {
    import TruckDimensions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.TruckDimensions
      .builder()
      .optionallyWith(
        height.map(value =>
          TruckDimensionsHeightDouble.unwrap(value): java.lang.Double
        )
      )(_.height)
      .optionallyWith(
        length.map(value =>
          TruckDimensionsLengthDouble.unwrap(value): java.lang.Double
        )
      )(_.length)
      .optionallyWith(unit.map(value => value.unwrap))(_.unit)
      .optionallyWith(
        width.map(value =>
          TruckDimensionsWidthDouble.unwrap(value): java.lang.Double
        )
      )(_.width)
      .build()
  }
  def asReadOnly: zio.aws.location.model.TruckDimensions.ReadOnly =
    zio.aws.location.model.TruckDimensions.wrap(buildAwsValue())
}
object TruckDimensions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.TruckDimensions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.TruckDimensions =
      zio.aws.location.model.TruckDimensions(
        height.map(value => value),
        length.map(value => value),
        unit.map(value => value),
        width.map(value => value)
      )
    def height: Optional[TruckDimensionsHeightDouble]
    def length: Optional[TruckDimensionsLengthDouble]
    def unit: Optional[zio.aws.location.model.DimensionUnit]
    def width: Optional[TruckDimensionsWidthDouble]
    def getHeight: ZIO[Any, AwsError, TruckDimensionsHeightDouble] =
      AwsError.unwrapOptionField("height", height)
    def getLength: ZIO[Any, AwsError, TruckDimensionsLengthDouble] =
      AwsError.unwrapOptionField("length", length)
    def getUnit: ZIO[Any, AwsError, zio.aws.location.model.DimensionUnit] =
      AwsError.unwrapOptionField("unit", unit)
    def getWidth: ZIO[Any, AwsError, TruckDimensionsWidthDouble] =
      AwsError.unwrapOptionField("width", width)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.TruckDimensions
  ) extends zio.aws.location.model.TruckDimensions.ReadOnly {
    override val height: Optional[TruckDimensionsHeightDouble] =
      zio.aws.core.internal
        .optionalFromNullable(impl.height())
        .map(value =>
          zio.aws.location.model.primitives.TruckDimensionsHeightDouble(value)
        )
    override val length: Optional[TruckDimensionsLengthDouble] =
      zio.aws.core.internal
        .optionalFromNullable(impl.length())
        .map(value =>
          zio.aws.location.model.primitives.TruckDimensionsLengthDouble(value)
        )
    override val unit: Optional[zio.aws.location.model.DimensionUnit] =
      zio.aws.core.internal
        .optionalFromNullable(impl.unit())
        .map(value => zio.aws.location.model.DimensionUnit.wrap(value))
    override val width: Optional[TruckDimensionsWidthDouble] =
      zio.aws.core.internal
        .optionalFromNullable(impl.width())
        .map(value =>
          zio.aws.location.model.primitives.TruckDimensionsWidthDouble(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.TruckDimensions
  ): zio.aws.location.model.TruckDimensions.ReadOnly = new Wrapper(impl)
}
