package zio.aws.location
import zio.aws.location.model.ListDevicePositionsResponse.ReadOnly
import zio.aws.location.model.primitives.Arn
import zio.mock.{Proxy, Mock}
import zio.aws.core.AwsError
import software.amazon.awssdk.services.location.LocationAsyncClient
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.aws.location.model.{
  CreateGeofenceCollectionRequest,
  GetMapSpritesRequest,
  DescribeGeofenceCollectionRequest,
  UpdateTrackerRequest,
  UpdateMapRequest,
  SearchPlaceIndexForTextRequest,
  BatchDeleteDevicePositionHistoryRequest,
  GetMapStyleDescriptorRequest,
  BatchUpdateDevicePositionRequest,
  DeletePlaceIndexRequest,
  UpdateRouteCalculatorRequest,
  SearchPlaceIndexForSuggestionsRequest,
  PutGeofenceRequest,
  CalculateRouteMatrixRequest,
  GetGeofenceRequest,
  BatchPutGeofenceRequest,
  CreateMapRequest,
  DescribeRouteCalculatorRequest,
  ListTagsForResourceRequest,
  BatchEvaluateGeofencesRequest,
  DisassociateTrackerConsumerRequest,
  GetDevicePositionHistoryRequest,
  DescribePlaceIndexRequest,
  CreateTrackerRequest,
  ListMapsRequest,
  DeleteRouteCalculatorRequest,
  BatchGetDevicePositionRequest,
  ListTrackersRequest,
  BatchDeleteGeofenceRequest,
  ListRouteCalculatorsRequest,
  GetDevicePositionRequest,
  UntagResourceRequest,
  UpdatePlaceIndexRequest,
  ListTrackerConsumersRequest,
  ListDevicePositionsRequest,
  UpdateGeofenceCollectionRequest,
  AssociateTrackerConsumerRequest,
  GetMapTileRequest,
  DeleteMapRequest,
  DescribeTrackerRequest,
  DeleteTrackerRequest,
  CalculateRouteRequest,
  CreatePlaceIndexRequest,
  ListGeofenceCollectionsRequest,
  ListPlaceIndexesRequest,
  SearchPlaceIndexForPositionRequest,
  ListGeofencesRequest,
  DeleteGeofenceCollectionRequest,
  CreateRouteCalculatorRequest,
  TagResourceRequest,
  DescribeMapRequest,
  GetMapGlyphsRequest
}
import zio.stream.ZStream
object LocationMock extends Mock[Location] {
  object ListMaps
      extends Stream[
        ListMapsRequest,
        AwsError,
        zio.aws.location.model.ListMapsResponseEntry.ReadOnly
      ]
  object ListMapsPaginated
      extends Effect[
        ListMapsRequest,
        AwsError,
        zio.aws.location.model.ListMapsResponse.ReadOnly
      ]
  object GetMapTile
      extends Effect[
        GetMapTileRequest,
        AwsError,
        zio.aws.location.model.GetMapTileResponse.ReadOnly
      ]
  object DescribeTracker
      extends Effect[
        DescribeTrackerRequest,
        AwsError,
        zio.aws.location.model.DescribeTrackerResponse.ReadOnly
      ]
  object DeleteMap
      extends Effect[
        DeleteMapRequest,
        AwsError,
        zio.aws.location.model.DeleteMapResponse.ReadOnly
      ]
  object UpdateGeofenceCollection
      extends Effect[
        UpdateGeofenceCollectionRequest,
        AwsError,
        zio.aws.location.model.UpdateGeofenceCollectionResponse.ReadOnly
      ]
  object DeleteTracker
      extends Effect[
        DeleteTrackerRequest,
        AwsError,
        zio.aws.location.model.DeleteTrackerResponse.ReadOnly
      ]
  object ListPlaceIndexes
      extends Stream[
        ListPlaceIndexesRequest,
        AwsError,
        zio.aws.location.model.ListPlaceIndexesResponseEntry.ReadOnly
      ]
  object ListPlaceIndexesPaginated
      extends Effect[
        ListPlaceIndexesRequest,
        AwsError,
        zio.aws.location.model.ListPlaceIndexesResponse.ReadOnly
      ]
  object GetMapGlyphs
      extends Effect[
        GetMapGlyphsRequest,
        AwsError,
        zio.aws.location.model.GetMapGlyphsResponse.ReadOnly
      ]
  object BatchEvaluateGeofences
      extends Effect[
        BatchEvaluateGeofencesRequest,
        AwsError,
        zio.aws.location.model.BatchEvaluateGeofencesResponse.ReadOnly
      ]
  object DeletePlaceIndex
      extends Effect[
        DeletePlaceIndexRequest,
        AwsError,
        zio.aws.location.model.DeletePlaceIndexResponse.ReadOnly
      ]
  object DescribeRouteCalculator
      extends Effect[
        DescribeRouteCalculatorRequest,
        AwsError,
        zio.aws.location.model.DescribeRouteCalculatorResponse.ReadOnly
      ]
  object CalculateRouteMatrix
      extends Effect[
        CalculateRouteMatrixRequest,
        AwsError,
        zio.aws.location.model.CalculateRouteMatrixResponse.ReadOnly
      ]
  object PutGeofence
      extends Effect[
        PutGeofenceRequest,
        AwsError,
        zio.aws.location.model.PutGeofenceResponse.ReadOnly
      ]
  object DeleteGeofenceCollection
      extends Effect[
        DeleteGeofenceCollectionRequest,
        AwsError,
        zio.aws.location.model.DeleteGeofenceCollectionResponse.ReadOnly
      ]
  object SearchPlaceIndexForText
      extends Effect[
        SearchPlaceIndexForTextRequest,
        AwsError,
        zio.aws.location.model.SearchPlaceIndexForTextResponse.ReadOnly
      ]
  object CreateRouteCalculator
      extends Effect[
        CreateRouteCalculatorRequest,
        AwsError,
        zio.aws.location.model.CreateRouteCalculatorResponse.ReadOnly
      ]
  object SearchPlaceIndexForPosition
      extends Effect[
        SearchPlaceIndexForPositionRequest,
        AwsError,
        zio.aws.location.model.SearchPlaceIndexForPositionResponse.ReadOnly
      ]
  object AssociateTrackerConsumer
      extends Effect[
        AssociateTrackerConsumerRequest,
        AwsError,
        zio.aws.location.model.AssociateTrackerConsumerResponse.ReadOnly
      ]
  object BatchDeleteDevicePositionHistory
      extends Effect[
        BatchDeleteDevicePositionHistoryRequest,
        AwsError,
        zio.aws.location.model.BatchDeleteDevicePositionHistoryResponse.ReadOnly
      ]
  object CalculateRoute
      extends Effect[
        CalculateRouteRequest,
        AwsError,
        zio.aws.location.model.CalculateRouteResponse.ReadOnly
      ]
  object CreateGeofenceCollection
      extends Effect[
        CreateGeofenceCollectionRequest,
        AwsError,
        zio.aws.location.model.CreateGeofenceCollectionResponse.ReadOnly
      ]
  object GetGeofence
      extends Effect[
        GetGeofenceRequest,
        AwsError,
        zio.aws.location.model.GetGeofenceResponse.ReadOnly
      ]
  object DescribeGeofenceCollection
      extends Effect[
        DescribeGeofenceCollectionRequest,
        AwsError,
        zio.aws.location.model.DescribeGeofenceCollectionResponse.ReadOnly
      ]
  object SearchPlaceIndexForSuggestions
      extends Effect[
        SearchPlaceIndexForSuggestionsRequest,
        AwsError,
        zio.aws.location.model.SearchPlaceIndexForSuggestionsResponse.ReadOnly
      ]
  object UpdateMap
      extends Effect[
        UpdateMapRequest,
        AwsError,
        zio.aws.location.model.UpdateMapResponse.ReadOnly
      ]
  object DeleteRouteCalculator
      extends Effect[
        DeleteRouteCalculatorRequest,
        AwsError,
        zio.aws.location.model.DeleteRouteCalculatorResponse.ReadOnly
      ]
  object GetMapStyleDescriptor
      extends Effect[
        GetMapStyleDescriptorRequest,
        AwsError,
        zio.aws.location.model.GetMapStyleDescriptorResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.location.model.UntagResourceResponse.ReadOnly
      ]
  object DisassociateTrackerConsumer
      extends Effect[
        DisassociateTrackerConsumerRequest,
        AwsError,
        zio.aws.location.model.DisassociateTrackerConsumerResponse.ReadOnly
      ]
  object GetDevicePositionHistory
      extends Stream[
        GetDevicePositionHistoryRequest,
        AwsError,
        zio.aws.location.model.DevicePosition.ReadOnly
      ]
  object GetDevicePositionHistoryPaginated
      extends Effect[
        GetDevicePositionHistoryRequest,
        AwsError,
        zio.aws.location.model.GetDevicePositionHistoryResponse.ReadOnly
      ]
  object BatchGetDevicePosition
      extends Effect[
        BatchGetDevicePositionRequest,
        AwsError,
        zio.aws.location.model.BatchGetDevicePositionResponse.ReadOnly
      ]
  object ListGeofenceCollections
      extends Stream[
        ListGeofenceCollectionsRequest,
        AwsError,
        zio.aws.location.model.ListGeofenceCollectionsResponseEntry.ReadOnly
      ]
  object ListGeofenceCollectionsPaginated
      extends Effect[
        ListGeofenceCollectionsRequest,
        AwsError,
        zio.aws.location.model.ListGeofenceCollectionsResponse.ReadOnly
      ]
  object DescribePlaceIndex
      extends Effect[
        DescribePlaceIndexRequest,
        AwsError,
        zio.aws.location.model.DescribePlaceIndexResponse.ReadOnly
      ]
  object UpdatePlaceIndex
      extends Effect[
        UpdatePlaceIndexRequest,
        AwsError,
        zio.aws.location.model.UpdatePlaceIndexResponse.ReadOnly
      ]
  object GetMapSprites
      extends Effect[
        GetMapSpritesRequest,
        AwsError,
        zio.aws.location.model.GetMapSpritesResponse.ReadOnly
      ]
  object ListRouteCalculators
      extends Stream[
        ListRouteCalculatorsRequest,
        AwsError,
        zio.aws.location.model.ListRouteCalculatorsResponseEntry.ReadOnly
      ]
  object ListRouteCalculatorsPaginated
      extends Effect[
        ListRouteCalculatorsRequest,
        AwsError,
        zio.aws.location.model.ListRouteCalculatorsResponse.ReadOnly
      ]
  object BatchUpdateDevicePosition
      extends Effect[
        BatchUpdateDevicePositionRequest,
        AwsError,
        zio.aws.location.model.BatchUpdateDevicePositionResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.location.model.ListTagsForResourceResponse.ReadOnly
      ]
  object ListTrackerConsumers
      extends Stream[ListTrackerConsumersRequest, AwsError, Arn]
  object ListTrackerConsumersPaginated
      extends Effect[
        ListTrackerConsumersRequest,
        AwsError,
        zio.aws.location.model.ListTrackerConsumersResponse.ReadOnly
      ]
  object CreatePlaceIndex
      extends Effect[
        CreatePlaceIndexRequest,
        AwsError,
        zio.aws.location.model.CreatePlaceIndexResponse.ReadOnly
      ]
  object UpdateRouteCalculator
      extends Effect[
        UpdateRouteCalculatorRequest,
        AwsError,
        zio.aws.location.model.UpdateRouteCalculatorResponse.ReadOnly
      ]
  object DescribeMap
      extends Effect[
        DescribeMapRequest,
        AwsError,
        zio.aws.location.model.DescribeMapResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.location.model.TagResourceResponse.ReadOnly
      ]
  object CreateTracker
      extends Effect[
        CreateTrackerRequest,
        AwsError,
        zio.aws.location.model.CreateTrackerResponse.ReadOnly
      ]
  object CreateMap
      extends Effect[
        CreateMapRequest,
        AwsError,
        zio.aws.location.model.CreateMapResponse.ReadOnly
      ]
  object ListTrackers
      extends Stream[
        ListTrackersRequest,
        AwsError,
        zio.aws.location.model.ListTrackersResponseEntry.ReadOnly
      ]
  object ListTrackersPaginated
      extends Effect[
        ListTrackersRequest,
        AwsError,
        zio.aws.location.model.ListTrackersResponse.ReadOnly
      ]
  object ListDevicePositions
      extends Stream[
        ListDevicePositionsRequest,
        AwsError,
        zio.aws.location.model.ListDevicePositionsResponseEntry.ReadOnly
      ]
  object ListDevicePositionsPaginated
      extends Effect[ListDevicePositionsRequest, AwsError, ReadOnly]
  object UpdateTracker
      extends Effect[
        UpdateTrackerRequest,
        AwsError,
        zio.aws.location.model.UpdateTrackerResponse.ReadOnly
      ]
  object GetDevicePosition
      extends Effect[
        GetDevicePositionRequest,
        AwsError,
        zio.aws.location.model.GetDevicePositionResponse.ReadOnly
      ]
  object ListGeofences
      extends Stream[
        ListGeofencesRequest,
        AwsError,
        zio.aws.location.model.ListGeofenceResponseEntry.ReadOnly
      ]
  object ListGeofencesPaginated
      extends Effect[
        ListGeofencesRequest,
        AwsError,
        zio.aws.location.model.ListGeofencesResponse.ReadOnly
      ]
  object BatchDeleteGeofence
      extends Effect[
        BatchDeleteGeofenceRequest,
        AwsError,
        zio.aws.location.model.BatchDeleteGeofenceResponse.ReadOnly
      ]
  object BatchPutGeofence
      extends Effect[
        BatchPutGeofenceRequest,
        AwsError,
        zio.aws.location.model.BatchPutGeofenceResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, Location] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, Location] { rts =>
        zio.ZIO.succeed {
          new Location {
            val api: LocationAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): Location = this
            def listMaps(request: ListMapsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.location.model.ListMapsResponseEntry.ReadOnly
            ] = rts.unsafeRun(proxy(ListMaps, request))
            def listMapsPaginated(
                request: ListMapsRequest
            ): IO[AwsError, zio.aws.location.model.ListMapsResponse.ReadOnly] =
              proxy(ListMapsPaginated, request)
            def getMapTile(request: GetMapTileRequest): IO[
              AwsError,
              zio.aws.location.model.GetMapTileResponse.ReadOnly
            ] = proxy(GetMapTile, request)
            def describeTracker(request: DescribeTrackerRequest): IO[
              AwsError,
              zio.aws.location.model.DescribeTrackerResponse.ReadOnly
            ] = proxy(DescribeTracker, request)
            def deleteMap(
                request: DeleteMapRequest
            ): IO[AwsError, zio.aws.location.model.DeleteMapResponse.ReadOnly] =
              proxy(DeleteMap, request)
            def updateGeofenceCollection(
                request: UpdateGeofenceCollectionRequest
            ): IO[
              AwsError,
              zio.aws.location.model.UpdateGeofenceCollectionResponse.ReadOnly
            ] = proxy(UpdateGeofenceCollection, request)
            def deleteTracker(request: DeleteTrackerRequest): IO[
              AwsError,
              zio.aws.location.model.DeleteTrackerResponse.ReadOnly
            ] = proxy(DeleteTracker, request)
            def listPlaceIndexes(request: ListPlaceIndexesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.location.model.ListPlaceIndexesResponseEntry.ReadOnly
            ] = rts.unsafeRun(proxy(ListPlaceIndexes, request))
            def listPlaceIndexesPaginated(request: ListPlaceIndexesRequest): IO[
              AwsError,
              zio.aws.location.model.ListPlaceIndexesResponse.ReadOnly
            ] = proxy(ListPlaceIndexesPaginated, request)
            def getMapGlyphs(request: GetMapGlyphsRequest): IO[
              AwsError,
              zio.aws.location.model.GetMapGlyphsResponse.ReadOnly
            ] = proxy(GetMapGlyphs, request)
            def batchEvaluateGeofences(
                request: BatchEvaluateGeofencesRequest
            ): IO[
              AwsError,
              zio.aws.location.model.BatchEvaluateGeofencesResponse.ReadOnly
            ] = proxy(BatchEvaluateGeofences, request)
            def deletePlaceIndex(request: DeletePlaceIndexRequest): IO[
              AwsError,
              zio.aws.location.model.DeletePlaceIndexResponse.ReadOnly
            ] = proxy(DeletePlaceIndex, request)
            def describeRouteCalculator(
                request: DescribeRouteCalculatorRequest
            ): IO[
              AwsError,
              zio.aws.location.model.DescribeRouteCalculatorResponse.ReadOnly
            ] = proxy(DescribeRouteCalculator, request)
            def calculateRouteMatrix(request: CalculateRouteMatrixRequest): IO[
              AwsError,
              zio.aws.location.model.CalculateRouteMatrixResponse.ReadOnly
            ] = proxy(CalculateRouteMatrix, request)
            def putGeofence(request: PutGeofenceRequest): IO[
              AwsError,
              zio.aws.location.model.PutGeofenceResponse.ReadOnly
            ] = proxy(PutGeofence, request)
            def deleteGeofenceCollection(
                request: DeleteGeofenceCollectionRequest
            ): IO[
              AwsError,
              zio.aws.location.model.DeleteGeofenceCollectionResponse.ReadOnly
            ] = proxy(DeleteGeofenceCollection, request)
            def searchPlaceIndexForText(
                request: SearchPlaceIndexForTextRequest
            ): IO[
              AwsError,
              zio.aws.location.model.SearchPlaceIndexForTextResponse.ReadOnly
            ] = proxy(SearchPlaceIndexForText, request)
            def createRouteCalculator(
                request: CreateRouteCalculatorRequest
            ): IO[
              AwsError,
              zio.aws.location.model.CreateRouteCalculatorResponse.ReadOnly
            ] = proxy(CreateRouteCalculator, request)
            def searchPlaceIndexForPosition(
                request: SearchPlaceIndexForPositionRequest
            ): IO[
              AwsError,
              zio.aws.location.model.SearchPlaceIndexForPositionResponse.ReadOnly
            ] = proxy(SearchPlaceIndexForPosition, request)
            def associateTrackerConsumer(
                request: AssociateTrackerConsumerRequest
            ): IO[
              AwsError,
              zio.aws.location.model.AssociateTrackerConsumerResponse.ReadOnly
            ] = proxy(AssociateTrackerConsumer, request)
            def batchDeleteDevicePositionHistory(
                request: BatchDeleteDevicePositionHistoryRequest
            ): IO[
              AwsError,
              zio.aws.location.model.BatchDeleteDevicePositionHistoryResponse.ReadOnly
            ] = proxy(BatchDeleteDevicePositionHistory, request)
            def calculateRoute(request: CalculateRouteRequest): IO[
              AwsError,
              zio.aws.location.model.CalculateRouteResponse.ReadOnly
            ] = proxy(CalculateRoute, request)
            def createGeofenceCollection(
                request: CreateGeofenceCollectionRequest
            ): IO[
              AwsError,
              zio.aws.location.model.CreateGeofenceCollectionResponse.ReadOnly
            ] = proxy(CreateGeofenceCollection, request)
            def getGeofence(request: GetGeofenceRequest): IO[
              AwsError,
              zio.aws.location.model.GetGeofenceResponse.ReadOnly
            ] = proxy(GetGeofence, request)
            def describeGeofenceCollection(
                request: DescribeGeofenceCollectionRequest
            ): IO[
              AwsError,
              zio.aws.location.model.DescribeGeofenceCollectionResponse.ReadOnly
            ] = proxy(DescribeGeofenceCollection, request)
            def searchPlaceIndexForSuggestions(
                request: SearchPlaceIndexForSuggestionsRequest
            ): IO[
              AwsError,
              zio.aws.location.model.SearchPlaceIndexForSuggestionsResponse.ReadOnly
            ] = proxy(SearchPlaceIndexForSuggestions, request)
            def updateMap(
                request: UpdateMapRequest
            ): IO[AwsError, zio.aws.location.model.UpdateMapResponse.ReadOnly] =
              proxy(UpdateMap, request)
            def deleteRouteCalculator(
                request: DeleteRouteCalculatorRequest
            ): IO[
              AwsError,
              zio.aws.location.model.DeleteRouteCalculatorResponse.ReadOnly
            ] = proxy(DeleteRouteCalculator, request)
            def getMapStyleDescriptor(
                request: GetMapStyleDescriptorRequest
            ): IO[
              AwsError,
              zio.aws.location.model.GetMapStyleDescriptorResponse.ReadOnly
            ] = proxy(GetMapStyleDescriptor, request)
            def untagResource(request: UntagResourceRequest): IO[
              AwsError,
              zio.aws.location.model.UntagResourceResponse.ReadOnly
            ] = proxy(UntagResource, request)
            def disassociateTrackerConsumer(
                request: DisassociateTrackerConsumerRequest
            ): IO[
              AwsError,
              zio.aws.location.model.DisassociateTrackerConsumerResponse.ReadOnly
            ] = proxy(DisassociateTrackerConsumer, request)
            def getDevicePositionHistory(
                request: GetDevicePositionHistoryRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.location.model.DevicePosition.ReadOnly
            ] = rts.unsafeRun(proxy(GetDevicePositionHistory, request))
            def getDevicePositionHistoryPaginated(
                request: GetDevicePositionHistoryRequest
            ): IO[
              AwsError,
              zio.aws.location.model.GetDevicePositionHistoryResponse.ReadOnly
            ] = proxy(GetDevicePositionHistoryPaginated, request)
            def batchGetDevicePosition(
                request: BatchGetDevicePositionRequest
            ): IO[
              AwsError,
              zio.aws.location.model.BatchGetDevicePositionResponse.ReadOnly
            ] = proxy(BatchGetDevicePosition, request)
            def listGeofenceCollections(
                request: ListGeofenceCollectionsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.location.model.ListGeofenceCollectionsResponseEntry.ReadOnly
            ] = rts.unsafeRun(proxy(ListGeofenceCollections, request))
            def listGeofenceCollectionsPaginated(
                request: ListGeofenceCollectionsRequest
            ): IO[
              AwsError,
              zio.aws.location.model.ListGeofenceCollectionsResponse.ReadOnly
            ] = proxy(ListGeofenceCollectionsPaginated, request)
            def describePlaceIndex(request: DescribePlaceIndexRequest): IO[
              AwsError,
              zio.aws.location.model.DescribePlaceIndexResponse.ReadOnly
            ] = proxy(DescribePlaceIndex, request)
            def updatePlaceIndex(request: UpdatePlaceIndexRequest): IO[
              AwsError,
              zio.aws.location.model.UpdatePlaceIndexResponse.ReadOnly
            ] = proxy(UpdatePlaceIndex, request)
            def getMapSprites(request: GetMapSpritesRequest): IO[
              AwsError,
              zio.aws.location.model.GetMapSpritesResponse.ReadOnly
            ] = proxy(GetMapSprites, request)
            def listRouteCalculators(
                request: ListRouteCalculatorsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.location.model.ListRouteCalculatorsResponseEntry.ReadOnly
            ] = rts.unsafeRun(proxy(ListRouteCalculators, request))
            def listRouteCalculatorsPaginated(
                request: ListRouteCalculatorsRequest
            ): IO[
              AwsError,
              zio.aws.location.model.ListRouteCalculatorsResponse.ReadOnly
            ] = proxy(ListRouteCalculatorsPaginated, request)
            def batchUpdateDevicePosition(
                request: BatchUpdateDevicePositionRequest
            ): IO[
              AwsError,
              zio.aws.location.model.BatchUpdateDevicePositionResponse.ReadOnly
            ] = proxy(BatchUpdateDevicePosition, request)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.location.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def listTrackerConsumers(
                request: ListTrackerConsumersRequest
            ): ZStream[Any, AwsError, Arn] =
              rts.unsafeRun(proxy(ListTrackerConsumers, request))
            def listTrackerConsumersPaginated(
                request: ListTrackerConsumersRequest
            ): IO[
              AwsError,
              zio.aws.location.model.ListTrackerConsumersResponse.ReadOnly
            ] = proxy(ListTrackerConsumersPaginated, request)
            def createPlaceIndex(request: CreatePlaceIndexRequest): IO[
              AwsError,
              zio.aws.location.model.CreatePlaceIndexResponse.ReadOnly
            ] = proxy(CreatePlaceIndex, request)
            def updateRouteCalculator(
                request: UpdateRouteCalculatorRequest
            ): IO[
              AwsError,
              zio.aws.location.model.UpdateRouteCalculatorResponse.ReadOnly
            ] = proxy(UpdateRouteCalculator, request)
            def describeMap(request: DescribeMapRequest): IO[
              AwsError,
              zio.aws.location.model.DescribeMapResponse.ReadOnly
            ] = proxy(DescribeMap, request)
            def tagResource(request: TagResourceRequest): IO[
              AwsError,
              zio.aws.location.model.TagResourceResponse.ReadOnly
            ] = proxy(TagResource, request)
            def createTracker(request: CreateTrackerRequest): IO[
              AwsError,
              zio.aws.location.model.CreateTrackerResponse.ReadOnly
            ] = proxy(CreateTracker, request)
            def createMap(
                request: CreateMapRequest
            ): IO[AwsError, zio.aws.location.model.CreateMapResponse.ReadOnly] =
              proxy(CreateMap, request)
            def listTrackers(request: ListTrackersRequest): ZStream[
              Any,
              AwsError,
              zio.aws.location.model.ListTrackersResponseEntry.ReadOnly
            ] = rts.unsafeRun(proxy(ListTrackers, request))
            def listTrackersPaginated(request: ListTrackersRequest): IO[
              AwsError,
              zio.aws.location.model.ListTrackersResponse.ReadOnly
            ] = proxy(ListTrackersPaginated, request)
            def listDevicePositions(
                request: ListDevicePositionsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.location.model.ListDevicePositionsResponseEntry.ReadOnly
            ] = rts.unsafeRun(proxy(ListDevicePositions, request))
            def listDevicePositionsPaginated(
                request: ListDevicePositionsRequest
            ): IO[AwsError, ReadOnly] =
              proxy(ListDevicePositionsPaginated, request)
            def updateTracker(request: UpdateTrackerRequest): IO[
              AwsError,
              zio.aws.location.model.UpdateTrackerResponse.ReadOnly
            ] = proxy(UpdateTracker, request)
            def getDevicePosition(request: GetDevicePositionRequest): IO[
              AwsError,
              zio.aws.location.model.GetDevicePositionResponse.ReadOnly
            ] = proxy(GetDevicePosition, request)
            def listGeofences(request: ListGeofencesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.location.model.ListGeofenceResponseEntry.ReadOnly
            ] = rts.unsafeRun(proxy(ListGeofences, request))
            def listGeofencesPaginated(request: ListGeofencesRequest): IO[
              AwsError,
              zio.aws.location.model.ListGeofencesResponse.ReadOnly
            ] = proxy(ListGeofencesPaginated, request)
            def batchDeleteGeofence(request: BatchDeleteGeofenceRequest): IO[
              AwsError,
              zio.aws.location.model.BatchDeleteGeofenceResponse.ReadOnly
            ] = proxy(BatchDeleteGeofence, request)
            def batchPutGeofence(request: BatchPutGeofenceRequest): IO[
              AwsError,
              zio.aws.location.model.BatchPutGeofenceResponse.ReadOnly
            ] = proxy(BatchPutGeofence, request)
          }
        }
      }
    }
  }
}
