package zio.aws.location.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class BatchDeleteDevicePositionHistoryResponse(
    errors: Iterable[
      zio.aws.location.model.BatchDeleteDevicePositionHistoryError
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.BatchDeleteDevicePositionHistoryResponse = {
    import BatchDeleteDevicePositionHistoryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.BatchDeleteDevicePositionHistoryResponse
      .builder()
      .errors(errors.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.location.model.BatchDeleteDevicePositionHistoryResponse.ReadOnly =
    zio.aws.location.model.BatchDeleteDevicePositionHistoryResponse
      .wrap(buildAwsValue())
}
object BatchDeleteDevicePositionHistoryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.BatchDeleteDevicePositionHistoryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.location.model.BatchDeleteDevicePositionHistoryResponse =
      zio.aws.location.model
        .BatchDeleteDevicePositionHistoryResponse(errors.map { item =>
          item.asEditable
        })
    def errors: List[
      zio.aws.location.model.BatchDeleteDevicePositionHistoryError.ReadOnly
    ]
    def getErrors: ZIO[Any, Nothing, List[
      zio.aws.location.model.BatchDeleteDevicePositionHistoryError.ReadOnly
    ]] = ZIO.succeed(errors)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.BatchDeleteDevicePositionHistoryResponse
  ) extends zio.aws.location.model.BatchDeleteDevicePositionHistoryResponse.ReadOnly {
    override val errors: List[
      zio.aws.location.model.BatchDeleteDevicePositionHistoryError.ReadOnly
    ] = impl
      .errors()
      .asScala
      .map { item =>
        zio.aws.location.model.BatchDeleteDevicePositionHistoryError.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.BatchDeleteDevicePositionHistoryResponse
  ): zio.aws.location.model.BatchDeleteDevicePositionHistoryResponse.ReadOnly =
    new Wrapper(impl)
}
