package zio.aws.location.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.location.model.primitives.{
  BatchGetDevicePositionRequestTrackerNameString,
  Id
}
import scala.jdk.CollectionConverters._
final case class BatchGetDevicePositionRequest(
    deviceIds: Iterable[Id],
    trackerName: BatchGetDevicePositionRequestTrackerNameString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.BatchGetDevicePositionRequest = {
    import BatchGetDevicePositionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.BatchGetDevicePositionRequest
      .builder()
      .deviceIds(deviceIds.map { item =>
        Id.unwrap(item): java.lang.String
      }.asJavaCollection)
      .trackerName(
        BatchGetDevicePositionRequestTrackerNameString.unwrap(
          trackerName
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.location.model.BatchGetDevicePositionRequest.ReadOnly =
    zio.aws.location.model.BatchGetDevicePositionRequest.wrap(buildAwsValue())
}
object BatchGetDevicePositionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.BatchGetDevicePositionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.BatchGetDevicePositionRequest =
      zio.aws.location.model
        .BatchGetDevicePositionRequest(deviceIds, trackerName)
    def deviceIds: List[Id]
    def trackerName: BatchGetDevicePositionRequestTrackerNameString
    def getDeviceIds: ZIO[Any, Nothing, List[Id]] = ZIO.succeed(deviceIds)
    def getTrackerName
        : ZIO[Any, Nothing, BatchGetDevicePositionRequestTrackerNameString] =
      ZIO.succeed(trackerName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.BatchGetDevicePositionRequest
  ) extends zio.aws.location.model.BatchGetDevicePositionRequest.ReadOnly {
    override val deviceIds: List[Id] = impl
      .deviceIds()
      .asScala
      .map { item =>
        zio.aws.location.model.primitives.Id(item)
      }
      .toList
    override val trackerName: BatchGetDevicePositionRequestTrackerNameString =
      zio.aws.location.model.primitives
        .BatchGetDevicePositionRequestTrackerNameString(impl.trackerName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.BatchGetDevicePositionRequest
  ): zio.aws.location.model.BatchGetDevicePositionRequest.ReadOnly =
    new Wrapper(impl)
}
