package zio.aws.location.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.location.model.primitives.ResourceName
import scala.jdk.CollectionConverters._
final case class BatchUpdateDevicePositionRequest(
    trackerName: ResourceName,
    updates: Iterable[zio.aws.location.model.DevicePositionUpdate]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.BatchUpdateDevicePositionRequest = {
    import BatchUpdateDevicePositionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.BatchUpdateDevicePositionRequest
      .builder()
      .trackerName(ResourceName.unwrap(trackerName): java.lang.String)
      .updates(updates.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.location.model.BatchUpdateDevicePositionRequest.ReadOnly =
    zio.aws.location.model.BatchUpdateDevicePositionRequest
      .wrap(buildAwsValue())
}
object BatchUpdateDevicePositionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.BatchUpdateDevicePositionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.BatchUpdateDevicePositionRequest =
      zio.aws.location.model.BatchUpdateDevicePositionRequest(
        trackerName,
        updates.map { item =>
          item.asEditable
        }
      )
    def trackerName: ResourceName
    def updates: List[zio.aws.location.model.DevicePositionUpdate.ReadOnly]
    def getTrackerName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(trackerName)
    def getUpdates: ZIO[Any, Nothing, List[
      zio.aws.location.model.DevicePositionUpdate.ReadOnly
    ]] = ZIO.succeed(updates)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.BatchUpdateDevicePositionRequest
  ) extends zio.aws.location.model.BatchUpdateDevicePositionRequest.ReadOnly {
    override val trackerName: ResourceName =
      zio.aws.location.model.primitives.ResourceName(impl.trackerName())
    override val updates
        : List[zio.aws.location.model.DevicePositionUpdate.ReadOnly] = impl
      .updates()
      .asScala
      .map { item =>
        zio.aws.location.model.DevicePositionUpdate.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.BatchUpdateDevicePositionRequest
  ): zio.aws.location.model.BatchUpdateDevicePositionRequest.ReadOnly =
    new Wrapper(impl)
}
