package zio.aws.location.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class BatchUpdateDevicePositionResponse(
    errors: Iterable[zio.aws.location.model.BatchUpdateDevicePositionError]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.BatchUpdateDevicePositionResponse = {
    import BatchUpdateDevicePositionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.BatchUpdateDevicePositionResponse
      .builder()
      .errors(errors.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.location.model.BatchUpdateDevicePositionResponse.ReadOnly =
    zio.aws.location.model.BatchUpdateDevicePositionResponse
      .wrap(buildAwsValue())
}
object BatchUpdateDevicePositionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.BatchUpdateDevicePositionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.BatchUpdateDevicePositionResponse =
      zio.aws.location.model.BatchUpdateDevicePositionResponse(errors.map {
        item =>
          item.asEditable
      })
    def errors
        : List[zio.aws.location.model.BatchUpdateDevicePositionError.ReadOnly]
    def getErrors: ZIO[Any, Nothing, List[
      zio.aws.location.model.BatchUpdateDevicePositionError.ReadOnly
    ]] = ZIO.succeed(errors)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.BatchUpdateDevicePositionResponse
  ) extends zio.aws.location.model.BatchUpdateDevicePositionResponse.ReadOnly {
    override val errors
        : List[zio.aws.location.model.BatchUpdateDevicePositionError.ReadOnly] =
      impl
        .errors()
        .asScala
        .map { item =>
          zio.aws.location.model.BatchUpdateDevicePositionError.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.BatchUpdateDevicePositionResponse
  ): zio.aws.location.model.BatchUpdateDevicePositionResponse.ReadOnly =
    new Wrapper(impl)
}
