package zio.aws.location.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CalculateRouteResponse(
    legs: Iterable[zio.aws.location.model.Leg],
    summary: zio.aws.location.model.CalculateRouteSummary
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.CalculateRouteResponse = {
    import CalculateRouteResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.CalculateRouteResponse
      .builder()
      .legs(legs.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .summary(summary.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.location.model.CalculateRouteResponse.ReadOnly =
    zio.aws.location.model.CalculateRouteResponse.wrap(buildAwsValue())
}
object CalculateRouteResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.CalculateRouteResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.CalculateRouteResponse =
      zio.aws.location.model.CalculateRouteResponse(
        legs.map { item =>
          item.asEditable
        },
        summary.asEditable
      )
    def legs: List[zio.aws.location.model.Leg.ReadOnly]
    def summary: zio.aws.location.model.CalculateRouteSummary.ReadOnly
    def getLegs: ZIO[Any, Nothing, List[zio.aws.location.model.Leg.ReadOnly]] =
      ZIO.succeed(legs)
    def getSummary: ZIO[
      Any,
      Nothing,
      zio.aws.location.model.CalculateRouteSummary.ReadOnly
    ] = ZIO.succeed(summary)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.CalculateRouteResponse
  ) extends zio.aws.location.model.CalculateRouteResponse.ReadOnly {
    override val legs: List[zio.aws.location.model.Leg.ReadOnly] = impl
      .legs()
      .asScala
      .map { item =>
        zio.aws.location.model.Leg.wrap(item)
      }
      .toList
    override val summary
        : zio.aws.location.model.CalculateRouteSummary.ReadOnly =
      zio.aws.location.model.CalculateRouteSummary.wrap(impl.summary())
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.CalculateRouteResponse
  ): zio.aws.location.model.CalculateRouteResponse.ReadOnly = new Wrapper(impl)
}
