package zio.aws.location.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CalculateRouteTruckModeOptions(
    avoidFerries: Optional[Boolean] = Optional.Absent,
    avoidTolls: Optional[Boolean] = Optional.Absent,
    dimensions: Optional[zio.aws.location.model.TruckDimensions] =
      Optional.Absent,
    weight: Optional[zio.aws.location.model.TruckWeight] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.CalculateRouteTruckModeOptions = {
    import CalculateRouteTruckModeOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.CalculateRouteTruckModeOptions
      .builder()
      .optionallyWith(avoidFerries.map(value => value: java.lang.Boolean))(
        _.avoidFerries
      )
      .optionallyWith(avoidTolls.map(value => value: java.lang.Boolean))(
        _.avoidTolls
      )
      .optionallyWith(dimensions.map(value => value.buildAwsValue()))(
        _.dimensions
      )
      .optionallyWith(weight.map(value => value.buildAwsValue()))(_.weight)
      .build()
  }
  def asReadOnly
      : zio.aws.location.model.CalculateRouteTruckModeOptions.ReadOnly =
    zio.aws.location.model.CalculateRouteTruckModeOptions.wrap(buildAwsValue())
}
object CalculateRouteTruckModeOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.CalculateRouteTruckModeOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.CalculateRouteTruckModeOptions =
      zio.aws.location.model.CalculateRouteTruckModeOptions(
        avoidFerries.map(value => value),
        avoidTolls.map(value => value),
        dimensions.map(value => value.asEditable),
        weight.map(value => value.asEditable)
      )
    def avoidFerries: Optional[Boolean]
    def avoidTolls: Optional[Boolean]
    def dimensions: Optional[zio.aws.location.model.TruckDimensions.ReadOnly]
    def weight: Optional[zio.aws.location.model.TruckWeight.ReadOnly]
    def getAvoidFerries: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("avoidFerries", avoidFerries)
    def getAvoidTolls: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("avoidTolls", avoidTolls)
    def getDimensions
        : ZIO[Any, AwsError, zio.aws.location.model.TruckDimensions.ReadOnly] =
      AwsError.unwrapOptionField("dimensions", dimensions)
    def getWeight
        : ZIO[Any, AwsError, zio.aws.location.model.TruckWeight.ReadOnly] =
      AwsError.unwrapOptionField("weight", weight)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.CalculateRouteTruckModeOptions
  ) extends zio.aws.location.model.CalculateRouteTruckModeOptions.ReadOnly {
    override val avoidFerries: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.avoidFerries())
      .map(value => value: Boolean)
    override val avoidTolls: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.avoidTolls())
      .map(value => value: Boolean)
    override val dimensions
        : Optional[zio.aws.location.model.TruckDimensions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dimensions())
        .map(value => zio.aws.location.model.TruckDimensions.wrap(value))
    override val weight: Optional[zio.aws.location.model.TruckWeight.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.weight())
        .map(value => zio.aws.location.model.TruckWeight.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.CalculateRouteTruckModeOptions
  ): zio.aws.location.model.CalculateRouteTruckModeOptions.ReadOnly =
    new Wrapper(impl)
}
