package zio.aws.location.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.location.model.primitives.{
  TagValue,
  TagKey,
  ResourceDescription,
  ResourceName
}
import scala.jdk.CollectionConverters._
final case class CreateRouteCalculatorRequest(
    calculatorName: ResourceName,
    dataSource: String,
    description: Optional[ResourceDescription] = Optional.Absent,
    pricingPlan: Optional[zio.aws.location.model.PricingPlan] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.CreateRouteCalculatorRequest = {
    import CreateRouteCalculatorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.CreateRouteCalculatorRequest
      .builder()
      .calculatorName(ResourceName.unwrap(calculatorName): java.lang.String)
      .dataSource(dataSource: java.lang.String)
      .optionallyWith(
        description.map(value =>
          ResourceDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(pricingPlan.map(value => value.unwrap))(_.pricingPlan)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.location.model.CreateRouteCalculatorRequest.ReadOnly =
    zio.aws.location.model.CreateRouteCalculatorRequest.wrap(buildAwsValue())
}
object CreateRouteCalculatorRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.CreateRouteCalculatorRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.CreateRouteCalculatorRequest =
      zio.aws.location.model.CreateRouteCalculatorRequest(
        calculatorName,
        dataSource,
        description.map(value => value),
        pricingPlan.map(value => value),
        tags.map(value => value)
      )
    def calculatorName: ResourceName
    def dataSource: String
    def description: Optional[ResourceDescription]
    def pricingPlan: Optional[zio.aws.location.model.PricingPlan]
    def tags: Optional[Map[TagKey, TagValue]]
    def getCalculatorName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(calculatorName)
    def getDataSource: ZIO[Any, Nothing, String] = ZIO.succeed(dataSource)
    def getDescription: ZIO[Any, AwsError, ResourceDescription] =
      AwsError.unwrapOptionField("description", description)
    def getPricingPlan: ZIO[Any, AwsError, zio.aws.location.model.PricingPlan] =
      AwsError.unwrapOptionField("pricingPlan", pricingPlan)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.CreateRouteCalculatorRequest
  ) extends zio.aws.location.model.CreateRouteCalculatorRequest.ReadOnly {
    override val calculatorName: ResourceName =
      zio.aws.location.model.primitives.ResourceName(impl.calculatorName())
    override val dataSource: String = impl.dataSource(): String
    override val description: Optional[ResourceDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.location.model.primitives.ResourceDescription(value)
        )
    override val pricingPlan: Optional[zio.aws.location.model.PricingPlan] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pricingPlan())
        .map(value => zio.aws.location.model.PricingPlan.wrap(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.location.model.primitives
              .TagKey(key) -> zio.aws.location.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.CreateRouteCalculatorRequest
  ): zio.aws.location.model.CreateRouteCalculatorRequest.ReadOnly = new Wrapper(
    impl
  )
}
