package zio.aws.location.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.location.model.primitives.ResourceName
import scala.jdk.CollectionConverters._
final case class DescribeGeofenceCollectionRequest(
    collectionName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.DescribeGeofenceCollectionRequest = {
    import DescribeGeofenceCollectionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.DescribeGeofenceCollectionRequest
      .builder()
      .collectionName(ResourceName.unwrap(collectionName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.location.model.DescribeGeofenceCollectionRequest.ReadOnly =
    zio.aws.location.model.DescribeGeofenceCollectionRequest
      .wrap(buildAwsValue())
}
object DescribeGeofenceCollectionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.DescribeGeofenceCollectionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.DescribeGeofenceCollectionRequest =
      zio.aws.location.model.DescribeGeofenceCollectionRequest(collectionName)
    def collectionName: ResourceName
    def getCollectionName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(collectionName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.DescribeGeofenceCollectionRequest
  ) extends zio.aws.location.model.DescribeGeofenceCollectionRequest.ReadOnly {
    override val collectionName: ResourceName =
      zio.aws.location.model.primitives.ResourceName(impl.collectionName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.DescribeGeofenceCollectionRequest
  ): zio.aws.location.model.DescribeGeofenceCollectionRequest.ReadOnly =
    new Wrapper(impl)
}
