package zio.aws.location.model
import zio.aws.location.model.primitives.{
  ResourceDescription,
  Timestamp,
  TagValue,
  Arn,
  ResourceName,
  TagKey
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DescribeMapResponse(
    configuration: zio.aws.location.model.MapConfiguration,
    createTime: Timestamp,
    dataSource: String,
    description: ResourceDescription,
    mapArn: Arn,
    mapName: ResourceName,
    pricingPlan: Optional[zio.aws.location.model.PricingPlan] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    updateTime: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.DescribeMapResponse = {
    import DescribeMapResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.DescribeMapResponse
      .builder()
      .configuration(configuration.buildAwsValue())
      .createTime(Timestamp.unwrap(createTime): Instant)
      .dataSource(dataSource: java.lang.String)
      .description(ResourceDescription.unwrap(description): java.lang.String)
      .mapArn(Arn.unwrap(mapArn): java.lang.String)
      .mapName(ResourceName.unwrap(mapName): java.lang.String)
      .optionallyWith(pricingPlan.map(value => value.unwrap))(_.pricingPlan)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .updateTime(Timestamp.unwrap(updateTime): Instant)
      .build()
  }
  def asReadOnly: zio.aws.location.model.DescribeMapResponse.ReadOnly =
    zio.aws.location.model.DescribeMapResponse.wrap(buildAwsValue())
}
object DescribeMapResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.DescribeMapResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.DescribeMapResponse =
      zio.aws.location.model.DescribeMapResponse(
        configuration.asEditable,
        createTime,
        dataSource,
        description,
        mapArn,
        mapName,
        pricingPlan.map(value => value),
        tags.map(value => value),
        updateTime
      )
    def configuration: zio.aws.location.model.MapConfiguration.ReadOnly
    def createTime: Timestamp
    def dataSource: String
    def description: ResourceDescription
    def mapArn: Arn
    def mapName: ResourceName
    def pricingPlan: Optional[zio.aws.location.model.PricingPlan]
    def tags: Optional[Map[TagKey, TagValue]]
    def updateTime: Timestamp
    def getConfiguration
        : ZIO[Any, Nothing, zio.aws.location.model.MapConfiguration.ReadOnly] =
      ZIO.succeed(configuration)
    def getCreateTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createTime)
    def getDataSource: ZIO[Any, Nothing, String] = ZIO.succeed(dataSource)
    def getDescription: ZIO[Any, Nothing, ResourceDescription] =
      ZIO.succeed(description)
    def getMapArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(mapArn)
    def getMapName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(mapName)
    def getPricingPlan: ZIO[Any, AwsError, zio.aws.location.model.PricingPlan] =
      AwsError.unwrapOptionField("pricingPlan", pricingPlan)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getUpdateTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(updateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.DescribeMapResponse
  ) extends zio.aws.location.model.DescribeMapResponse.ReadOnly {
    override val configuration
        : zio.aws.location.model.MapConfiguration.ReadOnly =
      zio.aws.location.model.MapConfiguration.wrap(impl.configuration())
    override val createTime: Timestamp =
      zio.aws.location.model.primitives.Timestamp(impl.createTime())
    override val dataSource: String = impl.dataSource(): String
    override val description: ResourceDescription =
      zio.aws.location.model.primitives.ResourceDescription(impl.description())
    override val mapArn: Arn =
      zio.aws.location.model.primitives.Arn(impl.mapArn())
    override val mapName: ResourceName =
      zio.aws.location.model.primitives.ResourceName(impl.mapName())
    override val pricingPlan: Optional[zio.aws.location.model.PricingPlan] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pricingPlan())
        .map(value => zio.aws.location.model.PricingPlan.wrap(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.location.model.primitives
              .TagKey(key) -> zio.aws.location.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val updateTime: Timestamp =
      zio.aws.location.model.primitives.Timestamp(impl.updateTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.DescribeMapResponse
  ): zio.aws.location.model.DescribeMapResponse.ReadOnly = new Wrapper(impl)
}
