package zio.aws.location.model
import zio.aws.location.model.primitives.{
  Timestamp,
  PropertyMapValueString,
  PropertyMapKeyString,
  Id
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DevicePosition(
    accuracy: Optional[zio.aws.location.model.PositionalAccuracy] =
      Optional.Absent,
    deviceId: Optional[Id] = Optional.Absent,
    position: Iterable[Double],
    positionProperties: Optional[
      Map[PropertyMapKeyString, PropertyMapValueString]
    ] = Optional.Absent,
    receivedTime: Timestamp,
    sampleTime: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.DevicePosition = {
    import DevicePosition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.DevicePosition
      .builder()
      .optionallyWith(accuracy.map(value => value.buildAwsValue()))(_.accuracy)
      .optionallyWith(
        deviceId.map(value => Id.unwrap(value): java.lang.String)
      )(_.deviceId)
      .position(position.map { item =>
        item: java.lang.Double
      }.asJavaCollection)
      .optionallyWith(
        positionProperties.map(value =>
          value
            .map({ case (key, value) =>
              (PropertyMapKeyString.unwrap(
                key
              ): java.lang.String) -> (PropertyMapValueString.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.positionProperties)
      .receivedTime(Timestamp.unwrap(receivedTime): Instant)
      .sampleTime(Timestamp.unwrap(sampleTime): Instant)
      .build()
  }
  def asReadOnly: zio.aws.location.model.DevicePosition.ReadOnly =
    zio.aws.location.model.DevicePosition.wrap(buildAwsValue())
}
object DevicePosition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.DevicePosition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.DevicePosition =
      zio.aws.location.model.DevicePosition(
        accuracy.map(value => value.asEditable),
        deviceId.map(value => value),
        position,
        positionProperties.map(value => value),
        receivedTime,
        sampleTime
      )
    def accuracy: Optional[zio.aws.location.model.PositionalAccuracy.ReadOnly]
    def deviceId: Optional[Id]
    def position: List[Double]
    def positionProperties
        : Optional[Map[PropertyMapKeyString, PropertyMapValueString]]
    def receivedTime: Timestamp
    def sampleTime: Timestamp
    def getAccuracy: ZIO[
      Any,
      AwsError,
      zio.aws.location.model.PositionalAccuracy.ReadOnly
    ] = AwsError.unwrapOptionField("accuracy", accuracy)
    def getDeviceId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("deviceId", deviceId)
    def getPosition: ZIO[Any, Nothing, List[Double]] = ZIO.succeed(position)
    def getPositionProperties: ZIO[Any, AwsError, Map[
      PropertyMapKeyString,
      PropertyMapValueString
    ]] = AwsError.unwrapOptionField("positionProperties", positionProperties)
    def getReceivedTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(receivedTime)
    def getSampleTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(sampleTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.DevicePosition
  ) extends zio.aws.location.model.DevicePosition.ReadOnly {
    override val accuracy
        : Optional[zio.aws.location.model.PositionalAccuracy.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accuracy())
        .map(value => zio.aws.location.model.PositionalAccuracy.wrap(value))
    override val deviceId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.deviceId())
      .map(value => zio.aws.location.model.primitives.Id(value))
    override val position: List[Double] = impl
      .position()
      .asScala
      .map { item =>
        item: Double
      }
      .toList
    override val positionProperties
        : Optional[Map[PropertyMapKeyString, PropertyMapValueString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.positionProperties())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.location.model.primitives
                .PropertyMapKeyString(key) -> zio.aws.location.model.primitives
                .PropertyMapValueString(value)
            })
            .toMap
        )
    override val receivedTime: Timestamp =
      zio.aws.location.model.primitives.Timestamp(impl.receivedTime())
    override val sampleTime: Timestamp =
      zio.aws.location.model.primitives.Timestamp(impl.sampleTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.DevicePosition
  ): zio.aws.location.model.DevicePosition.ReadOnly = new Wrapper(impl)
}
