package zio.aws.location.model
import scala.jdk.CollectionConverters._
sealed trait DimensionUnit {
  def unwrap: software.amazon.awssdk.services.location.model.DimensionUnit
}
object DimensionUnit {
  def wrap(
      value: software.amazon.awssdk.services.location.model.DimensionUnit
  ): zio.aws.location.model.DimensionUnit = value match {
    case software.amazon.awssdk.services.location.model.DimensionUnit.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.location.model.DimensionUnit.METERS =>
      val r = Meters
      r
    case software.amazon.awssdk.services.location.model.DimensionUnit.FEET =>
      val r = Feet
      r
  }
  case object unknownToSdkVersion extends zio.aws.location.model.DimensionUnit {
    override def unwrap
        : software.amazon.awssdk.services.location.model.DimensionUnit =
      software.amazon.awssdk.services.location.model.DimensionUnit.UNKNOWN_TO_SDK_VERSION
  }
  case object Meters extends zio.aws.location.model.DimensionUnit {
    override def unwrap
        : software.amazon.awssdk.services.location.model.DimensionUnit =
      software.amazon.awssdk.services.location.model.DimensionUnit.METERS
  }
  case object Feet extends zio.aws.location.model.DimensionUnit {
    override def unwrap
        : software.amazon.awssdk.services.location.model.DimensionUnit =
      software.amazon.awssdk.services.location.model.DimensionUnit.FEET
  }
}
