package zio.aws.location.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.location.model.primitives.{ResourceName, Id}
import scala.jdk.CollectionConverters._
final case class GetDevicePositionRequest(
    deviceId: Id,
    trackerName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.GetDevicePositionRequest = {
    import GetDevicePositionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.GetDevicePositionRequest
      .builder()
      .deviceId(Id.unwrap(deviceId): java.lang.String)
      .trackerName(ResourceName.unwrap(trackerName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.location.model.GetDevicePositionRequest.ReadOnly =
    zio.aws.location.model.GetDevicePositionRequest.wrap(buildAwsValue())
}
object GetDevicePositionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.GetDevicePositionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.GetDevicePositionRequest =
      zio.aws.location.model.GetDevicePositionRequest(deviceId, trackerName)
    def deviceId: Id
    def trackerName: ResourceName
    def getDeviceId: ZIO[Any, Nothing, Id] = ZIO.succeed(deviceId)
    def getTrackerName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(trackerName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.GetDevicePositionRequest
  ) extends zio.aws.location.model.GetDevicePositionRequest.ReadOnly {
    override val deviceId: Id =
      zio.aws.location.model.primitives.Id(impl.deviceId())
    override val trackerName: ResourceName =
      zio.aws.location.model.primitives.ResourceName(impl.trackerName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.GetDevicePositionRequest
  ): zio.aws.location.model.GetDevicePositionRequest.ReadOnly = new Wrapper(
    impl
  )
}
