package zio.aws.location.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.location.model.primitives.{
  ResourceName,
  GetMapSpritesRequestFileNameString
}
import scala.jdk.CollectionConverters._
final case class GetMapSpritesRequest(
    fileName: GetMapSpritesRequestFileNameString,
    mapName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.GetMapSpritesRequest = {
    import GetMapSpritesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.GetMapSpritesRequest
      .builder()
      .fileName(
        GetMapSpritesRequestFileNameString.unwrap(fileName): java.lang.String
      )
      .mapName(ResourceName.unwrap(mapName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.location.model.GetMapSpritesRequest.ReadOnly =
    zio.aws.location.model.GetMapSpritesRequest.wrap(buildAwsValue())
}
object GetMapSpritesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.GetMapSpritesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.GetMapSpritesRequest =
      zio.aws.location.model.GetMapSpritesRequest(fileName, mapName)
    def fileName: GetMapSpritesRequestFileNameString
    def mapName: ResourceName
    def getFileName: ZIO[Any, Nothing, GetMapSpritesRequestFileNameString] =
      ZIO.succeed(fileName)
    def getMapName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(mapName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.GetMapSpritesRequest
  ) extends zio.aws.location.model.GetMapSpritesRequest.ReadOnly {
    override val fileName: GetMapSpritesRequestFileNameString =
      zio.aws.location.model.primitives
        .GetMapSpritesRequestFileNameString(impl.fileName())
    override val mapName: ResourceName =
      zio.aws.location.model.primitives.ResourceName(impl.mapName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.GetMapSpritesRequest
  ): zio.aws.location.model.GetMapSpritesRequest.ReadOnly = new Wrapper(impl)
}
