package zio.aws.location.model
import zio.aws.location.model.primitives.{
  ResourceName,
  Token,
  ListDevicePositionsRequestMaxResultsInteger
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListDevicePositionsRequest(
    maxResults: Optional[ListDevicePositionsRequestMaxResultsInteger] =
      Optional.Absent,
    nextToken: Optional[Token] = Optional.Absent,
    trackerName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.ListDevicePositionsRequest = {
    import ListDevicePositionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.ListDevicePositionsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value =>
          ListDevicePositionsRequestMaxResultsInteger.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .trackerName(ResourceName.unwrap(trackerName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.location.model.ListDevicePositionsRequest.ReadOnly =
    zio.aws.location.model.ListDevicePositionsRequest.wrap(buildAwsValue())
}
object ListDevicePositionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.ListDevicePositionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.ListDevicePositionsRequest =
      zio.aws.location.model.ListDevicePositionsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        trackerName
      )
    def maxResults: Optional[ListDevicePositionsRequestMaxResultsInteger]
    def nextToken: Optional[Token]
    def trackerName: ResourceName
    def getMaxResults
        : ZIO[Any, AwsError, ListDevicePositionsRequestMaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getTrackerName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(trackerName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.ListDevicePositionsRequest
  ) extends zio.aws.location.model.ListDevicePositionsRequest.ReadOnly {
    override val maxResults
        : Optional[ListDevicePositionsRequestMaxResultsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.location.model.primitives
            .ListDevicePositionsRequestMaxResultsInteger(value)
        )
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.location.model.primitives.Token(value))
    override val trackerName: ResourceName =
      zio.aws.location.model.primitives.ResourceName(impl.trackerName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.ListDevicePositionsRequest
  ): zio.aws.location.model.ListDevicePositionsRequest.ReadOnly = new Wrapper(
    impl
  )
}
