package zio.aws.location.model
import zio.aws.location.model.primitives.{
  Timestamp,
  PropertyMapValueString,
  PropertyMapKeyString,
  Id
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class ListDevicePositionsResponseEntry(
    accuracy: Optional[zio.aws.location.model.PositionalAccuracy] =
      Optional.Absent,
    deviceId: Id,
    position: Iterable[Double],
    positionProperties: Optional[
      Map[PropertyMapKeyString, PropertyMapValueString]
    ] = Optional.Absent,
    sampleTime: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.ListDevicePositionsResponseEntry = {
    import ListDevicePositionsResponseEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.ListDevicePositionsResponseEntry
      .builder()
      .optionallyWith(accuracy.map(value => value.buildAwsValue()))(_.accuracy)
      .deviceId(Id.unwrap(deviceId): java.lang.String)
      .position(position.map { item =>
        item: java.lang.Double
      }.asJavaCollection)
      .optionallyWith(
        positionProperties.map(value =>
          value
            .map({ case (key, value) =>
              (PropertyMapKeyString
                .unwrap(key): java.lang.String) -> (PropertyMapValueString
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.positionProperties)
      .sampleTime(Timestamp.unwrap(sampleTime): Instant)
      .build()
  }
  def asReadOnly
      : zio.aws.location.model.ListDevicePositionsResponseEntry.ReadOnly =
    zio.aws.location.model.ListDevicePositionsResponseEntry
      .wrap(buildAwsValue())
}
object ListDevicePositionsResponseEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.ListDevicePositionsResponseEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.ListDevicePositionsResponseEntry =
      zio.aws.location.model.ListDevicePositionsResponseEntry(
        accuracy.map(value => value.asEditable),
        deviceId,
        position,
        positionProperties.map(value => value),
        sampleTime
      )
    def accuracy: Optional[zio.aws.location.model.PositionalAccuracy.ReadOnly]
    def deviceId: Id
    def position: List[Double]
    def positionProperties
        : Optional[Map[PropertyMapKeyString, PropertyMapValueString]]
    def sampleTime: Timestamp
    def getAccuracy: ZIO[
      Any,
      AwsError,
      zio.aws.location.model.PositionalAccuracy.ReadOnly
    ] = AwsError.unwrapOptionField("accuracy", accuracy)
    def getDeviceId: ZIO[Any, Nothing, Id] = ZIO.succeed(deviceId)
    def getPosition: ZIO[Any, Nothing, List[Double]] = ZIO.succeed(position)
    def getPositionProperties: ZIO[Any, AwsError, Map[
      PropertyMapKeyString,
      PropertyMapValueString
    ]] = AwsError.unwrapOptionField("positionProperties", positionProperties)
    def getSampleTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(sampleTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.ListDevicePositionsResponseEntry
  ) extends zio.aws.location.model.ListDevicePositionsResponseEntry.ReadOnly {
    override val accuracy
        : Optional[zio.aws.location.model.PositionalAccuracy.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accuracy())
        .map(value => zio.aws.location.model.PositionalAccuracy.wrap(value))
    override val deviceId: Id =
      zio.aws.location.model.primitives.Id(impl.deviceId())
    override val position: List[Double] = impl
      .position()
      .asScala
      .map { item =>
        item: Double
      }
      .toList
    override val positionProperties
        : Optional[Map[PropertyMapKeyString, PropertyMapValueString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.positionProperties())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.location.model.primitives
                .PropertyMapKeyString(key) -> zio.aws.location.model.primitives
                .PropertyMapValueString(value)
            })
            .toMap
        )
    override val sampleTime: Timestamp =
      zio.aws.location.model.primitives.Timestamp(impl.sampleTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.ListDevicePositionsResponseEntry
  ): zio.aws.location.model.ListDevicePositionsResponseEntry.ReadOnly =
    new Wrapper(impl)
}
