package zio.aws.location.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.location.model.primitives.Token
import scala.jdk.CollectionConverters._
final case class ListRouteCalculatorsResponse(
    entries: Iterable[zio.aws.location.model.ListRouteCalculatorsResponseEntry],
    nextToken: Optional[Token] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.ListRouteCalculatorsResponse = {
    import ListRouteCalculatorsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.ListRouteCalculatorsResponse
      .builder()
      .entries(entries.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.location.model.ListRouteCalculatorsResponse.ReadOnly =
    zio.aws.location.model.ListRouteCalculatorsResponse.wrap(buildAwsValue())
}
object ListRouteCalculatorsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.ListRouteCalculatorsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.ListRouteCalculatorsResponse =
      zio.aws.location.model.ListRouteCalculatorsResponse(
        entries.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def entries: List[
      zio.aws.location.model.ListRouteCalculatorsResponseEntry.ReadOnly
    ]
    def nextToken: Optional[Token]
    def getEntries: ZIO[Any, Nothing, List[
      zio.aws.location.model.ListRouteCalculatorsResponseEntry.ReadOnly
    ]] = ZIO.succeed(entries)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.ListRouteCalculatorsResponse
  ) extends zio.aws.location.model.ListRouteCalculatorsResponse.ReadOnly {
    override val entries: List[
      zio.aws.location.model.ListRouteCalculatorsResponseEntry.ReadOnly
    ] = impl
      .entries()
      .asScala
      .map { item =>
        zio.aws.location.model.ListRouteCalculatorsResponseEntry.wrap(item)
      }
      .toList
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.location.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.ListRouteCalculatorsResponse
  ): zio.aws.location.model.ListRouteCalculatorsResponse.ReadOnly = new Wrapper(
    impl
  )
}
