package zio.aws.location.model
import zio.aws.location.model.primitives.{
  ResourceDescription,
  Timestamp,
  ResourceName
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class ListRouteCalculatorsResponseEntry(
    calculatorName: ResourceName,
    createTime: Timestamp,
    dataSource: String,
    description: ResourceDescription,
    pricingPlan: Optional[zio.aws.location.model.PricingPlan] = Optional.Absent,
    updateTime: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.ListRouteCalculatorsResponseEntry = {
    import ListRouteCalculatorsResponseEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.ListRouteCalculatorsResponseEntry
      .builder()
      .calculatorName(ResourceName.unwrap(calculatorName): java.lang.String)
      .createTime(Timestamp.unwrap(createTime): Instant)
      .dataSource(dataSource: java.lang.String)
      .description(ResourceDescription.unwrap(description): java.lang.String)
      .optionallyWith(pricingPlan.map(value => value.unwrap))(_.pricingPlan)
      .updateTime(Timestamp.unwrap(updateTime): Instant)
      .build()
  }
  def asReadOnly
      : zio.aws.location.model.ListRouteCalculatorsResponseEntry.ReadOnly =
    zio.aws.location.model.ListRouteCalculatorsResponseEntry
      .wrap(buildAwsValue())
}
object ListRouteCalculatorsResponseEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.ListRouteCalculatorsResponseEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.ListRouteCalculatorsResponseEntry =
      zio.aws.location.model.ListRouteCalculatorsResponseEntry(
        calculatorName,
        createTime,
        dataSource,
        description,
        pricingPlan.map(value => value),
        updateTime
      )
    def calculatorName: ResourceName
    def createTime: Timestamp
    def dataSource: String
    def description: ResourceDescription
    def pricingPlan: Optional[zio.aws.location.model.PricingPlan]
    def updateTime: Timestamp
    def getCalculatorName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(calculatorName)
    def getCreateTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createTime)
    def getDataSource: ZIO[Any, Nothing, String] = ZIO.succeed(dataSource)
    def getDescription: ZIO[Any, Nothing, ResourceDescription] =
      ZIO.succeed(description)
    def getPricingPlan: ZIO[Any, AwsError, zio.aws.location.model.PricingPlan] =
      AwsError.unwrapOptionField("pricingPlan", pricingPlan)
    def getUpdateTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(updateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.ListRouteCalculatorsResponseEntry
  ) extends zio.aws.location.model.ListRouteCalculatorsResponseEntry.ReadOnly {
    override val calculatorName: ResourceName =
      zio.aws.location.model.primitives.ResourceName(impl.calculatorName())
    override val createTime: Timestamp =
      zio.aws.location.model.primitives.Timestamp(impl.createTime())
    override val dataSource: String = impl.dataSource(): String
    override val description: ResourceDescription =
      zio.aws.location.model.primitives.ResourceDescription(impl.description())
    override val pricingPlan: Optional[zio.aws.location.model.PricingPlan] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pricingPlan())
        .map(value => zio.aws.location.model.PricingPlan.wrap(value))
    override val updateTime: Timestamp =
      zio.aws.location.model.primitives.Timestamp(impl.updateTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.ListRouteCalculatorsResponseEntry
  ): zio.aws.location.model.ListRouteCalculatorsResponseEntry.ReadOnly =
    new Wrapper(impl)
}
