package zio.aws.location.model
import zio.aws.location.model.primitives.{
  ResourceName,
  Token,
  ListTrackerConsumersRequestMaxResultsInteger
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListTrackerConsumersRequest(
    maxResults: Optional[ListTrackerConsumersRequestMaxResultsInteger] =
      Optional.Absent,
    nextToken: Optional[Token] = Optional.Absent,
    trackerName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.ListTrackerConsumersRequest = {
    import ListTrackerConsumersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.ListTrackerConsumersRequest
      .builder()
      .optionallyWith(
        maxResults.map(value =>
          ListTrackerConsumersRequestMaxResultsInteger.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .trackerName(ResourceName.unwrap(trackerName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.location.model.ListTrackerConsumersRequest.ReadOnly =
    zio.aws.location.model.ListTrackerConsumersRequest.wrap(buildAwsValue())
}
object ListTrackerConsumersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.ListTrackerConsumersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.ListTrackerConsumersRequest =
      zio.aws.location.model.ListTrackerConsumersRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        trackerName
      )
    def maxResults: Optional[ListTrackerConsumersRequestMaxResultsInteger]
    def nextToken: Optional[Token]
    def trackerName: ResourceName
    def getMaxResults
        : ZIO[Any, AwsError, ListTrackerConsumersRequestMaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getTrackerName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(trackerName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.ListTrackerConsumersRequest
  ) extends zio.aws.location.model.ListTrackerConsumersRequest.ReadOnly {
    override val maxResults
        : Optional[ListTrackerConsumersRequestMaxResultsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.location.model.primitives
            .ListTrackerConsumersRequestMaxResultsInteger(value)
        )
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.location.model.primitives.Token(value))
    override val trackerName: ResourceName =
      zio.aws.location.model.primitives.ResourceName(impl.trackerName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.ListTrackerConsumersRequest
  ): zio.aws.location.model.ListTrackerConsumersRequest.ReadOnly = new Wrapper(
    impl
  )
}
