package zio.aws.location.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.location.model.primitives.{Token, Arn}
import scala.jdk.CollectionConverters._
final case class ListTrackerConsumersResponse(
    consumerArns: Iterable[Arn],
    nextToken: Optional[Token] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.ListTrackerConsumersResponse = {
    import ListTrackerConsumersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.ListTrackerConsumersResponse
      .builder()
      .consumerArns(consumerArns.map { item =>
        Arn.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.location.model.ListTrackerConsumersResponse.ReadOnly =
    zio.aws.location.model.ListTrackerConsumersResponse.wrap(buildAwsValue())
}
object ListTrackerConsumersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.ListTrackerConsumersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.ListTrackerConsumersResponse =
      zio.aws.location.model.ListTrackerConsumersResponse(
        consumerArns,
        nextToken.map(value => value)
      )
    def consumerArns: List[Arn]
    def nextToken: Optional[Token]
    def getConsumerArns: ZIO[Any, Nothing, List[Arn]] =
      ZIO.succeed(consumerArns)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.ListTrackerConsumersResponse
  ) extends zio.aws.location.model.ListTrackerConsumersResponse.ReadOnly {
    override val consumerArns: List[Arn] = impl
      .consumerArns()
      .asScala
      .map { item =>
        zio.aws.location.model.primitives.Arn(item)
      }
      .toList
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.location.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.ListTrackerConsumersResponse
  ): zio.aws.location.model.ListTrackerConsumersResponse.ReadOnly = new Wrapper(
    impl
  )
}
