package zio.aws.location.model
import zio.aws.location.model.primitives.{
  ResourceName,
  ResourceDescription,
  Timestamp
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class ListTrackersResponseEntry(
    createTime: Timestamp,
    description: ResourceDescription,
    pricingPlan: Optional[zio.aws.location.model.PricingPlan] = Optional.Absent,
    pricingPlanDataSource: Optional[String] = Optional.Absent,
    trackerName: ResourceName,
    updateTime: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.ListTrackersResponseEntry = {
    import ListTrackersResponseEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.ListTrackersResponseEntry
      .builder()
      .createTime(Timestamp.unwrap(createTime): Instant)
      .description(ResourceDescription.unwrap(description): java.lang.String)
      .optionallyWith(pricingPlan.map(value => value.unwrap))(_.pricingPlan)
      .optionallyWith(
        pricingPlanDataSource.map(value => value: java.lang.String)
      )(_.pricingPlanDataSource)
      .trackerName(ResourceName.unwrap(trackerName): java.lang.String)
      .updateTime(Timestamp.unwrap(updateTime): Instant)
      .build()
  }
  def asReadOnly: zio.aws.location.model.ListTrackersResponseEntry.ReadOnly =
    zio.aws.location.model.ListTrackersResponseEntry.wrap(buildAwsValue())
}
object ListTrackersResponseEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.ListTrackersResponseEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.ListTrackersResponseEntry =
      zio.aws.location.model.ListTrackersResponseEntry(
        createTime,
        description,
        pricingPlan.map(value => value),
        pricingPlanDataSource.map(value => value),
        trackerName,
        updateTime
      )
    def createTime: Timestamp
    def description: ResourceDescription
    def pricingPlan: Optional[zio.aws.location.model.PricingPlan]
    def pricingPlanDataSource: Optional[String]
    def trackerName: ResourceName
    def updateTime: Timestamp
    def getCreateTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createTime)
    def getDescription: ZIO[Any, Nothing, ResourceDescription] =
      ZIO.succeed(description)
    def getPricingPlan: ZIO[Any, AwsError, zio.aws.location.model.PricingPlan] =
      AwsError.unwrapOptionField("pricingPlan", pricingPlan)
    def getPricingPlanDataSource: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("pricingPlanDataSource", pricingPlanDataSource)
    def getTrackerName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(trackerName)
    def getUpdateTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(updateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.ListTrackersResponseEntry
  ) extends zio.aws.location.model.ListTrackersResponseEntry.ReadOnly {
    override val createTime: Timestamp =
      zio.aws.location.model.primitives.Timestamp(impl.createTime())
    override val description: ResourceDescription =
      zio.aws.location.model.primitives.ResourceDescription(impl.description())
    override val pricingPlan: Optional[zio.aws.location.model.PricingPlan] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pricingPlan())
        .map(value => zio.aws.location.model.PricingPlan.wrap(value))
    override val pricingPlanDataSource: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.pricingPlanDataSource())
      .map(value => value: String)
    override val trackerName: ResourceName =
      zio.aws.location.model.primitives.ResourceName(impl.trackerName())
    override val updateTime: Timestamp =
      zio.aws.location.model.primitives.Timestamp(impl.updateTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.ListTrackersResponseEntry
  ): zio.aws.location.model.ListTrackersResponseEntry.ReadOnly = new Wrapper(
    impl
  )
}
