package zio.aws.location.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Place(
    addressNumber: Optional[String] = Optional.Absent,
    country: Optional[String] = Optional.Absent,
    geometry: zio.aws.location.model.PlaceGeometry,
    interpolated: Optional[Boolean] = Optional.Absent,
    label: Optional[String] = Optional.Absent,
    municipality: Optional[String] = Optional.Absent,
    neighborhood: Optional[String] = Optional.Absent,
    postalCode: Optional[String] = Optional.Absent,
    region: Optional[String] = Optional.Absent,
    street: Optional[String] = Optional.Absent,
    subRegion: Optional[String] = Optional.Absent,
    timeZone: Optional[zio.aws.location.model.TimeZone] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.location.model.Place = {
    import Place.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.Place
      .builder()
      .optionallyWith(addressNumber.map(value => value: java.lang.String))(
        _.addressNumber
      )
      .optionallyWith(country.map(value => value: java.lang.String))(_.country)
      .geometry(geometry.buildAwsValue())
      .optionallyWith(interpolated.map(value => value: java.lang.Boolean))(
        _.interpolated
      )
      .optionallyWith(label.map(value => value: java.lang.String))(_.label)
      .optionallyWith(municipality.map(value => value: java.lang.String))(
        _.municipality
      )
      .optionallyWith(neighborhood.map(value => value: java.lang.String))(
        _.neighborhood
      )
      .optionallyWith(postalCode.map(value => value: java.lang.String))(
        _.postalCode
      )
      .optionallyWith(region.map(value => value: java.lang.String))(_.region)
      .optionallyWith(street.map(value => value: java.lang.String))(_.street)
      .optionallyWith(subRegion.map(value => value: java.lang.String))(
        _.subRegion
      )
      .optionallyWith(timeZone.map(value => value.buildAwsValue()))(_.timeZone)
      .build()
  }
  def asReadOnly: zio.aws.location.model.Place.ReadOnly =
    zio.aws.location.model.Place.wrap(buildAwsValue())
}
object Place {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.location.model.Place] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.Place = zio.aws.location.model.Place(
      addressNumber.map(value => value),
      country.map(value => value),
      geometry.asEditable,
      interpolated.map(value => value),
      label.map(value => value),
      municipality.map(value => value),
      neighborhood.map(value => value),
      postalCode.map(value => value),
      region.map(value => value),
      street.map(value => value),
      subRegion.map(value => value),
      timeZone.map(value => value.asEditable)
    )
    def addressNumber: Optional[String]
    def country: Optional[String]
    def geometry: zio.aws.location.model.PlaceGeometry.ReadOnly
    def interpolated: Optional[Boolean]
    def label: Optional[String]
    def municipality: Optional[String]
    def neighborhood: Optional[String]
    def postalCode: Optional[String]
    def region: Optional[String]
    def street: Optional[String]
    def subRegion: Optional[String]
    def timeZone: Optional[zio.aws.location.model.TimeZone.ReadOnly]
    def getAddressNumber: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("addressNumber", addressNumber)
    def getCountry: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("country", country)
    def getGeometry
        : ZIO[Any, Nothing, zio.aws.location.model.PlaceGeometry.ReadOnly] =
      ZIO.succeed(geometry)
    def getInterpolated: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("interpolated", interpolated)
    def getLabel: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("label", label)
    def getMunicipality: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("municipality", municipality)
    def getNeighborhood: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("neighborhood", neighborhood)
    def getPostalCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("postalCode", postalCode)
    def getRegion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("region", region)
    def getStreet: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("street", street)
    def getSubRegion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("subRegion", subRegion)
    def getTimeZone
        : ZIO[Any, AwsError, zio.aws.location.model.TimeZone.ReadOnly] =
      AwsError.unwrapOptionField("timeZone", timeZone)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.Place
  ) extends zio.aws.location.model.Place.ReadOnly {
    override val addressNumber: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.addressNumber())
      .map(value => value: String)
    override val country: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.country())
      .map(value => value: String)
    override val geometry: zio.aws.location.model.PlaceGeometry.ReadOnly =
      zio.aws.location.model.PlaceGeometry.wrap(impl.geometry())
    override val interpolated: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.interpolated())
      .map(value => value: Boolean)
    override val label: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.label())
      .map(value => value: String)
    override val municipality: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.municipality())
      .map(value => value: String)
    override val neighborhood: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.neighborhood())
      .map(value => value: String)
    override val postalCode: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.postalCode())
      .map(value => value: String)
    override val region: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.region())
      .map(value => value: String)
    override val street: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.street())
      .map(value => value: String)
    override val subRegion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.subRegion())
      .map(value => value: String)
    override val timeZone: Optional[zio.aws.location.model.TimeZone.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.timeZone())
        .map(value => zio.aws.location.model.TimeZone.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.Place
  ): zio.aws.location.model.Place.ReadOnly = new Wrapper(impl)
}
