package zio.aws.location.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.location.model.primitives.PositionalAccuracyHorizontalDouble
import scala.jdk.CollectionConverters._
final case class PositionalAccuracy(
    horizontal: PositionalAccuracyHorizontalDouble
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.PositionalAccuracy = {
    import PositionalAccuracy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.PositionalAccuracy
      .builder()
      .horizontal(
        PositionalAccuracyHorizontalDouble.unwrap(horizontal): java.lang.Double
      )
      .build()
  }
  def asReadOnly: zio.aws.location.model.PositionalAccuracy.ReadOnly =
    zio.aws.location.model.PositionalAccuracy.wrap(buildAwsValue())
}
object PositionalAccuracy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.PositionalAccuracy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.PositionalAccuracy =
      zio.aws.location.model.PositionalAccuracy(horizontal)
    def horizontal: PositionalAccuracyHorizontalDouble
    def getHorizontal: ZIO[Any, Nothing, PositionalAccuracyHorizontalDouble] =
      ZIO.succeed(horizontal)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.PositionalAccuracy
  ) extends zio.aws.location.model.PositionalAccuracy.ReadOnly {
    override val horizontal: PositionalAccuracyHorizontalDouble =
      zio.aws.location.model.primitives
        .PositionalAccuracyHorizontalDouble(impl.horizontal())
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.PositionalAccuracy
  ): zio.aws.location.model.PositionalAccuracy.ReadOnly = new Wrapper(impl)
}
