package zio.aws.location.model
import scala.jdk.CollectionConverters._
sealed trait PricingPlan {
  def unwrap: software.amazon.awssdk.services.location.model.PricingPlan
}
object PricingPlan {
  def wrap(
      value: software.amazon.awssdk.services.location.model.PricingPlan
  ): zio.aws.location.model.PricingPlan = value match {
    case software.amazon.awssdk.services.location.model.PricingPlan.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.location.model.PricingPlan.REQUEST_BASED_USAGE =>
      val r = RequestBasedUsage
      r
    case software.amazon.awssdk.services.location.model.PricingPlan.MOBILE_ASSET_TRACKING =>
      val r = MobileAssetTracking
      r
    case software.amazon.awssdk.services.location.model.PricingPlan.MOBILE_ASSET_MANAGEMENT =>
      val r = MobileAssetManagement
      r
  }
  case object unknownToSdkVersion extends zio.aws.location.model.PricingPlan {
    override def unwrap
        : software.amazon.awssdk.services.location.model.PricingPlan =
      software.amazon.awssdk.services.location.model.PricingPlan.UNKNOWN_TO_SDK_VERSION
  }
  case object RequestBasedUsage extends zio.aws.location.model.PricingPlan {
    override def unwrap
        : software.amazon.awssdk.services.location.model.PricingPlan =
      software.amazon.awssdk.services.location.model.PricingPlan.REQUEST_BASED_USAGE
  }
  case object MobileAssetTracking extends zio.aws.location.model.PricingPlan {
    override def unwrap
        : software.amazon.awssdk.services.location.model.PricingPlan =
      software.amazon.awssdk.services.location.model.PricingPlan.MOBILE_ASSET_TRACKING
  }
  case object MobileAssetManagement extends zio.aws.location.model.PricingPlan {
    override def unwrap
        : software.amazon.awssdk.services.location.model.PricingPlan =
      software.amazon.awssdk.services.location.model.PricingPlan.MOBILE_ASSET_MANAGEMENT
  }
}
