package zio.aws.location.model
import scala.jdk.CollectionConverters._
sealed trait RouteMatrixErrorCode {
  def unwrap
      : software.amazon.awssdk.services.location.model.RouteMatrixErrorCode
}
object RouteMatrixErrorCode {
  def wrap(
      value: software.amazon.awssdk.services.location.model.RouteMatrixErrorCode
  ): zio.aws.location.model.RouteMatrixErrorCode = value match {
    case software.amazon.awssdk.services.location.model.RouteMatrixErrorCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.location.model.RouteMatrixErrorCode.ROUTE_NOT_FOUND =>
      val r = RouteNotFound
      r
    case software.amazon.awssdk.services.location.model.RouteMatrixErrorCode.ROUTE_TOO_LONG =>
      val r = RouteTooLong
      r
    case software.amazon.awssdk.services.location.model.RouteMatrixErrorCode.POSITIONS_NOT_FOUND =>
      val r = PositionsNotFound
      r
    case software.amazon.awssdk.services.location.model.RouteMatrixErrorCode.DESTINATION_POSITION_NOT_FOUND =>
      val r = DestinationPositionNotFound
      r
    case software.amazon.awssdk.services.location.model.RouteMatrixErrorCode.DEPARTURE_POSITION_NOT_FOUND =>
      val r = DeparturePositionNotFound
      r
    case software.amazon.awssdk.services.location.model.RouteMatrixErrorCode.OTHER_VALIDATION_ERROR =>
      val r = OtherValidationError
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.location.model.RouteMatrixErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.location.model.RouteMatrixErrorCode =
      software.amazon.awssdk.services.location.model.RouteMatrixErrorCode.UNKNOWN_TO_SDK_VERSION
  }
  case object RouteNotFound
      extends zio.aws.location.model.RouteMatrixErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.location.model.RouteMatrixErrorCode =
      software.amazon.awssdk.services.location.model.RouteMatrixErrorCode.ROUTE_NOT_FOUND
  }
  case object RouteTooLong extends zio.aws.location.model.RouteMatrixErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.location.model.RouteMatrixErrorCode =
      software.amazon.awssdk.services.location.model.RouteMatrixErrorCode.ROUTE_TOO_LONG
  }
  case object PositionsNotFound
      extends zio.aws.location.model.RouteMatrixErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.location.model.RouteMatrixErrorCode =
      software.amazon.awssdk.services.location.model.RouteMatrixErrorCode.POSITIONS_NOT_FOUND
  }
  case object DestinationPositionNotFound
      extends zio.aws.location.model.RouteMatrixErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.location.model.RouteMatrixErrorCode =
      software.amazon.awssdk.services.location.model.RouteMatrixErrorCode.DESTINATION_POSITION_NOT_FOUND
  }
  case object DeparturePositionNotFound
      extends zio.aws.location.model.RouteMatrixErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.location.model.RouteMatrixErrorCode =
      software.amazon.awssdk.services.location.model.RouteMatrixErrorCode.DEPARTURE_POSITION_NOT_FOUND
  }
  case object OtherValidationError
      extends zio.aws.location.model.RouteMatrixErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.location.model.RouteMatrixErrorCode =
      software.amazon.awssdk.services.location.model.RouteMatrixErrorCode.OTHER_VALIDATION_ERROR
  }
}
