package zio.aws.location.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.location.model.primitives.Arn
import scala.jdk.CollectionConverters._
final case class UntagResourceRequest(
    resourceArn: Arn,
    tagKeys: Iterable[String]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.UntagResourceRequest = {
    import UntagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.UntagResourceRequest
      .builder()
      .resourceArn(Arn.unwrap(resourceArn): java.lang.String)
      .tagKeys(tagKeys.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.location.model.UntagResourceRequest.ReadOnly =
    zio.aws.location.model.UntagResourceRequest.wrap(buildAwsValue())
}
object UntagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.UntagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.UntagResourceRequest =
      zio.aws.location.model.UntagResourceRequest(resourceArn, tagKeys)
    def resourceArn: Arn
    def tagKeys: List[String]
    def getResourceArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(resourceArn)
    def getTagKeys: ZIO[Any, Nothing, List[String]] = ZIO.succeed(tagKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.UntagResourceRequest
  ) extends zio.aws.location.model.UntagResourceRequest.ReadOnly {
    override val resourceArn: Arn =
      zio.aws.location.model.primitives.Arn(impl.resourceArn())
    override val tagKeys: List[String] = impl
      .tagKeys()
      .asScala
      .map { item =>
        item: String
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.UntagResourceRequest
  ): zio.aws.location.model.UntagResourceRequest.ReadOnly = new Wrapper(impl)
}
