package zio.aws.location.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import zio.aws.location.model.primitives.{Timestamp, ResourceName, Arn}
import scala.jdk.CollectionConverters._
final case class UpdateMapResponse(
    mapArn: Arn,
    mapName: ResourceName,
    updateTime: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.UpdateMapResponse = {
    import UpdateMapResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.UpdateMapResponse
      .builder()
      .mapArn(Arn.unwrap(mapArn): java.lang.String)
      .mapName(ResourceName.unwrap(mapName): java.lang.String)
      .updateTime(Timestamp.unwrap(updateTime): Instant)
      .build()
  }
  def asReadOnly: zio.aws.location.model.UpdateMapResponse.ReadOnly =
    zio.aws.location.model.UpdateMapResponse.wrap(buildAwsValue())
}
object UpdateMapResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.UpdateMapResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.UpdateMapResponse =
      zio.aws.location.model.UpdateMapResponse(mapArn, mapName, updateTime)
    def mapArn: Arn
    def mapName: ResourceName
    def updateTime: Timestamp
    def getMapArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(mapArn)
    def getMapName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(mapName)
    def getUpdateTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(updateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.UpdateMapResponse
  ) extends zio.aws.location.model.UpdateMapResponse.ReadOnly {
    override val mapArn: Arn =
      zio.aws.location.model.primitives.Arn(impl.mapArn())
    override val mapName: ResourceName =
      zio.aws.location.model.primitives.ResourceName(impl.mapName())
    override val updateTime: Timestamp =
      zio.aws.location.model.primitives.Timestamp(impl.updateTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.UpdateMapResponse
  ): zio.aws.location.model.UpdateMapResponse.ReadOnly = new Wrapper(impl)
}
