package zio.aws.location.model
import scala.jdk.CollectionConverters._
sealed trait VehicleWeightUnit {
  def unwrap: software.amazon.awssdk.services.location.model.VehicleWeightUnit
}
object VehicleWeightUnit {
  def wrap(
      value: software.amazon.awssdk.services.location.model.VehicleWeightUnit
  ): zio.aws.location.model.VehicleWeightUnit = value match {
    case software.amazon.awssdk.services.location.model.VehicleWeightUnit.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.location.model.VehicleWeightUnit.KILOGRAMS =>
      val r = Kilograms
      r
    case software.amazon.awssdk.services.location.model.VehicleWeightUnit.POUNDS =>
      val r = Pounds
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.location.model.VehicleWeightUnit {
    override def unwrap
        : software.amazon.awssdk.services.location.model.VehicleWeightUnit =
      software.amazon.awssdk.services.location.model.VehicleWeightUnit.UNKNOWN_TO_SDK_VERSION
  }
  case object Kilograms extends zio.aws.location.model.VehicleWeightUnit {
    override def unwrap
        : software.amazon.awssdk.services.location.model.VehicleWeightUnit =
      software.amazon.awssdk.services.location.model.VehicleWeightUnit.KILOGRAMS
  }
  case object Pounds extends zio.aws.location.model.VehicleWeightUnit {
    override def unwrap
        : software.amazon.awssdk.services.location.model.VehicleWeightUnit =
      software.amazon.awssdk.services.location.model.VehicleWeightUnit.POUNDS
  }
}
