package zio.aws.location.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ApiKeyFilter(
    keyStatus: Optional[zio.aws.location.model.Status] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.location.model.ApiKeyFilter = {
    import ApiKeyFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.location.model.ApiKeyFilter
      .builder()
      .optionallyWith(keyStatus.map(value => value.unwrap))(_.keyStatus)
      .build()
  }
  def asReadOnly: zio.aws.location.model.ApiKeyFilter.ReadOnly =
    zio.aws.location.model.ApiKeyFilter.wrap(buildAwsValue())
}
object ApiKeyFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.location.model.ApiKeyFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.location.model.ApiKeyFilter =
      zio.aws.location.model.ApiKeyFilter(keyStatus.map(value => value))
    def keyStatus: Optional[zio.aws.location.model.Status]
    def getKeyStatus: ZIO[Any, AwsError, zio.aws.location.model.Status] =
      AwsError.unwrapOptionField("keyStatus", keyStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.location.model.ApiKeyFilter
  ) extends zio.aws.location.model.ApiKeyFilter.ReadOnly {
    override val keyStatus: Optional[zio.aws.location.model.Status] =
      zio.aws.core.internal
        .optionalFromNullable(impl.keyStatus())
        .map(value => zio.aws.location.model.Status.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.location.model.ApiKeyFilter
  ): zio.aws.location.model.ApiKeyFilter.ReadOnly = new Wrapper(impl)
}
